/*
 * Decompiled with CFR 0.152.
 */
package karate.io.micrometer.observation.aop;

import karate.io.micrometer.common.KeyValues;
import karate.io.micrometer.common.docs.KeyName;
import karate.io.micrometer.common.lang.Nullable;
import karate.io.micrometer.observation.Observation;
import karate.io.micrometer.observation.ObservationConvention;
import karate.io.micrometer.observation.ObservationRegistry;
import karate.io.micrometer.observation.annotation.Observed;
import karate.io.micrometer.observation.aop.ObservedAspect;
import karate.io.micrometer.observation.docs.ObservationDocumentation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;

enum ObservedAspectObservationDocumentation implements ObservationDocumentation
{
    DEFAULT;


    static Observation of(ProceedingJoinPoint pjp, Observed observed, ObservationRegistry registry, @Nullable ObservationConvention<ObservedAspect.ObservedAspectContext> observationConvention) {
        String name = observed.name().isEmpty() ? "method.observed" : observed.name();
        Signature signature = pjp.getStaticPart().getSignature();
        String contextualName = observed.contextualName().isEmpty() ? signature.getDeclaringType().getSimpleName() + "#" + signature.getName() : observed.contextualName();
        Observation observation = Observation.createNotStarted(name, () -> new ObservedAspect.ObservedAspectContext(pjp), registry).contextualName(contextualName).lowCardinalityKeyValue(ObservedAspectLowCardinalityKeyName.CLASS_NAME.asString(), signature.getDeclaringTypeName()).lowCardinalityKeyValue(ObservedAspectLowCardinalityKeyName.METHOD_NAME.asString(), signature.getName()).lowCardinalityKeyValues(KeyValues.of(observed.lowCardinalityKeyValues()));
        if (observationConvention != null) {
            observation.observationConvention(observationConvention);
        }
        return observation;
    }

    @Override
    public String getName() {
        return "%s";
    }

    @Override
    public String getContextualName() {
        return "%s";
    }

    @Override
    public KeyName[] getLowCardinalityKeyNames() {
        return ObservedAspectLowCardinalityKeyName.values();
    }

    static enum ObservedAspectLowCardinalityKeyName implements KeyName
    {
        CLASS_NAME{

            @Override
            public String asString() {
                return "class";
            }
        }
        ,
        METHOD_NAME{

            @Override
            public String asString() {
                return "method";
            }
        };

    }
}

