/*
 * Decompiled with CFR 0.152.
 */
package karate.io.netty.handler.address;

import java.net.SocketAddress;
import karate.io.netty.channel.ChannelHandler;
import karate.io.netty.channel.ChannelHandlerContext;
import karate.io.netty.channel.ChannelOutboundHandlerAdapter;
import karate.io.netty.channel.ChannelPromise;
import karate.io.netty.resolver.AddressResolver;
import karate.io.netty.resolver.AddressResolverGroup;
import karate.io.netty.util.concurrent.Future;
import karate.io.netty.util.concurrent.FutureListener;
import karate.io.netty.util.concurrent.GenericFutureListener;
import karate.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class ResolveAddressHandler
extends ChannelOutboundHandlerAdapter {
    private final AddressResolverGroup<? extends SocketAddress> resolverGroup;

    public ResolveAddressHandler(AddressResolverGroup<? extends SocketAddress> resolverGroup) {
        this.resolverGroup = ObjectUtil.checkNotNull(resolverGroup, "resolverGroup");
    }

    @Override
    public void connect(final ChannelHandlerContext ctx, SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelPromise promise) {
        AddressResolver<? extends SocketAddress> resolver = this.resolverGroup.getResolver(ctx.executor());
        if (resolver.isSupported(remoteAddress) && !resolver.isResolved(remoteAddress)) {
            resolver.resolve(remoteAddress).addListener((GenericFutureListener<Future<? extends SocketAddress>>)new FutureListener<SocketAddress>(){

                @Override
                public void operationComplete(Future<SocketAddress> future) {
                    Throwable cause = future.cause();
                    if (cause != null) {
                        promise.setFailure(cause);
                    } else {
                        ctx.connect(future.getNow(), localAddress, promise);
                    }
                    ctx.pipeline().remove(ResolveAddressHandler.this);
                }
            });
        } else {
            ctx.connect(remoteAddress, localAddress, promise);
            ctx.pipeline().remove(this);
        }
    }
}

