/*
 * Decompiled with CFR 0.152.
 */
package karate.io.netty.handler.codec.dns;

import java.net.InetSocketAddress;
import java.util.List;
import karate.io.netty.buffer.ByteBuf;
import karate.io.netty.channel.ChannelHandler;
import karate.io.netty.channel.ChannelHandlerContext;
import karate.io.netty.channel.socket.DatagramPacket;
import karate.io.netty.handler.codec.MessageToMessageDecoder;
import karate.io.netty.handler.codec.dns.DatagramDnsQuery;
import karate.io.netty.handler.codec.dns.DnsMessageUtil;
import karate.io.netty.handler.codec.dns.DnsOpCode;
import karate.io.netty.handler.codec.dns.DnsQuery;
import karate.io.netty.handler.codec.dns.DnsRecordDecoder;
import karate.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class DatagramDnsQueryDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private final DnsRecordDecoder recordDecoder;

    public DatagramDnsQueryDecoder() {
        this(DnsRecordDecoder.DEFAULT);
    }

    public DatagramDnsQueryDecoder(DnsRecordDecoder recordDecoder) {
        this.recordDecoder = ObjectUtil.checkNotNull(recordDecoder, "recordDecoder");
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, final DatagramPacket packet, List<Object> out) throws Exception {
        DnsQuery query = DnsMessageUtil.decodeDnsQuery(this.recordDecoder, (ByteBuf)packet.content(), new DnsMessageUtil.DnsQueryFactory(){

            @Override
            public DnsQuery newQuery(int id, DnsOpCode dnsOpCode) {
                return new DatagramDnsQuery((InetSocketAddress)packet.sender(), (InetSocketAddress)packet.recipient(), id, dnsOpCode);
            }
        });
        out.add(query);
    }
}

