/*
 * Decompiled with CFR 0.152.
 */
package karate.io.netty.handler.codec.dns;

import java.util.List;
import karate.io.netty.buffer.ByteBuf;
import karate.io.netty.channel.ChannelHandler;
import karate.io.netty.channel.ChannelHandlerContext;
import karate.io.netty.handler.codec.MessageToMessageEncoder;
import karate.io.netty.handler.codec.dns.DnsMessageUtil;
import karate.io.netty.handler.codec.dns.DnsRecordEncoder;
import karate.io.netty.handler.codec.dns.DnsResponse;
import karate.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public final class TcpDnsResponseEncoder
extends MessageToMessageEncoder<DnsResponse> {
    private final DnsRecordEncoder encoder;

    public TcpDnsResponseEncoder() {
        this(DnsRecordEncoder.DEFAULT);
    }

    public TcpDnsResponseEncoder(DnsRecordEncoder encoder) {
        this.encoder = ObjectUtil.checkNotNull(encoder, "encoder");
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, DnsResponse response, List<Object> out) throws Exception {
        ByteBuf buf = ctx.alloc().ioBuffer(1024);
        buf.writerIndex(buf.writerIndex() + 2);
        DnsMessageUtil.encodeDnsResponse(this.encoder, response, buf);
        buf.setShort(0, buf.readableBytes() - 2);
        out.add(buf);
    }
}

