/*
 * Decompiled with CFR 0.152.
 */
package karate.org.apache.http.impl.io;

import java.io.IOException;
import karate.org.apache.http.ConnectionClosedException;
import karate.org.apache.http.HttpException;
import karate.org.apache.http.HttpRequest;
import karate.org.apache.http.HttpRequestFactory;
import karate.org.apache.http.ParseException;
import karate.org.apache.http.RequestLine;
import karate.org.apache.http.config.MessageConstraints;
import karate.org.apache.http.impl.DefaultHttpRequestFactory;
import karate.org.apache.http.impl.io.AbstractMessageParser;
import karate.org.apache.http.io.SessionInputBuffer;
import karate.org.apache.http.message.LineParser;
import karate.org.apache.http.message.ParserCursor;
import karate.org.apache.http.params.HttpParams;
import karate.org.apache.http.util.Args;
import karate.org.apache.http.util.CharArrayBuffer;

public class DefaultHttpRequestParser
extends AbstractMessageParser<HttpRequest> {
    private final HttpRequestFactory requestFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser lineParser, HttpRequestFactory requestFactory, HttpParams params) {
        super(buffer, lineParser, params);
        this.requestFactory = Args.notNull(requestFactory, "Request factory");
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser lineParser, HttpRequestFactory requestFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpRequest parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int readLen = sessionBuffer.readLine(this.lineBuf);
        if (readLen == -1) {
            throw new ConnectionClosedException("Client closed connection");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        RequestLine requestline = this.lineParser.parseRequestLine(this.lineBuf, cursor);
        return this.requestFactory.newHttpRequest(requestline);
    }
}

