/*
 * Decompiled with CFR 0.152.
 */
package karate.org.apache.http.impl.io;

import karate.org.apache.http.HttpRequest;
import karate.org.apache.http.HttpRequestFactory;
import karate.org.apache.http.annotation.Contract;
import karate.org.apache.http.annotation.ThreadingBehavior;
import karate.org.apache.http.config.MessageConstraints;
import karate.org.apache.http.impl.DefaultHttpRequestFactory;
import karate.org.apache.http.impl.io.DefaultHttpRequestParser;
import karate.org.apache.http.io.HttpMessageParser;
import karate.org.apache.http.io.HttpMessageParserFactory;
import karate.org.apache.http.io.SessionInputBuffer;
import karate.org.apache.http.message.BasicLineParser;
import karate.org.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements HttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
    }
}

