/*
 * Decompiled with CFR 0.152.
 */
package karate.org.apache.http.protocol;

import java.io.IOException;
import karate.org.apache.http.HttpException;
import karate.org.apache.http.HttpRequest;
import karate.org.apache.http.HttpRequestInterceptor;
import karate.org.apache.http.annotation.Contract;
import karate.org.apache.http.annotation.ThreadingBehavior;
import karate.org.apache.http.protocol.HttpContext;
import karate.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

