/*
 * Decompiled with CFR 0.152.
 */
package karate.org.apache.http.protocol;

import java.io.IOException;
import karate.org.apache.http.HttpEntityEnclosingRequest;
import karate.org.apache.http.HttpException;
import karate.org.apache.http.HttpRequest;
import karate.org.apache.http.HttpRequestInterceptor;
import karate.org.apache.http.annotation.Contract;
import karate.org.apache.http.annotation.ThreadingBehavior;
import karate.org.apache.http.protocol.HttpContext;
import karate.org.apache.http.protocol.HttpDateGenerator;
import karate.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

