/*
 * Decompiled with CFR 0.152.
 */
package karate.org.apache.http.protocol;

import java.io.IOException;
import karate.org.apache.http.HttpEntity;
import karate.org.apache.http.HttpEntityEnclosingRequest;
import karate.org.apache.http.HttpException;
import karate.org.apache.http.HttpRequest;
import karate.org.apache.http.HttpRequestInterceptor;
import karate.org.apache.http.HttpVersion;
import karate.org.apache.http.ProtocolVersion;
import karate.org.apache.http.annotation.Contract;
import karate.org.apache.http.annotation.ThreadingBehavior;
import karate.org.apache.http.protocol.HttpContext;
import karate.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

