/*
 * Decompiled with CFR 0.152.
 */
package karate.org.attoparser;

import karate.org.attoparser.HtmlCDATAContentElement;
import karate.org.attoparser.IMarkupHandler;
import karate.org.attoparser.ParseException;
import karate.org.attoparser.ParseStatus;

class HtmlAutoOpenCDATAContentElement
extends HtmlCDATAContentElement {
    private final char[][] autoOpenParents;
    private final char[][] autoOpenLimits;

    public HtmlAutoOpenCDATAContentElement(String name, String[] autoOpenParents, String[] autoOpenLimits) {
        super(name);
        Object autoOpenLimitsCharArray;
        if (autoOpenParents == null) {
            throw new IllegalArgumentException("The array of auto-open parents cannot be null");
        }
        char[][] autoOpenParentsCharArray = new char[autoOpenParents.length][];
        for (int i = 0; i < autoOpenParentsCharArray.length; ++i) {
            autoOpenParentsCharArray[i] = autoOpenParents[i].toCharArray();
        }
        if (autoOpenLimits != null) {
            autoOpenLimitsCharArray = new char[autoOpenLimits.length][];
            for (int i = 0; i < ((char[][])autoOpenLimitsCharArray).length; ++i) {
                autoOpenLimitsCharArray[i] = autoOpenLimits[i].toCharArray();
            }
        } else {
            autoOpenLimitsCharArray = null;
        }
        this.autoOpenParents = autoOpenParentsCharArray;
        this.autoOpenLimits = autoOpenLimitsCharArray;
    }

    @Override
    public void handleOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col, IMarkupHandler handler, ParseStatus status, boolean autoOpenEnabled, boolean autoCloseEnabled) throws ParseException {
        if (autoOpenEnabled && !status.isAutoOpenCloseDone()) {
            status.setAutoOpenRequired(this.autoOpenParents, this.autoOpenLimits);
            return;
        }
        super.handleOpenElementStart(buffer, nameOffset, nameLen, line, col, handler, status, autoOpenEnabled, autoCloseEnabled);
    }

    @Override
    public void handleStandaloneElementStart(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col, IMarkupHandler handler, ParseStatus status, boolean autoOpenEnabled, boolean autoCloseEnabled) throws ParseException {
        if (autoOpenEnabled && !status.isAutoOpenCloseDone()) {
            status.setAutoOpenRequired(this.autoOpenParents, this.autoOpenLimits);
            return;
        }
        super.handleStandaloneElementStart(buffer, nameOffset, nameLen, minimized, line, col, handler, status, autoOpenEnabled, autoCloseEnabled);
    }
}

