/*
 * Decompiled with CFR 0.152.
 */
package karate.org.attoparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import karate.org.attoparser.HtmlAutoOpenCloseElement;
import karate.org.attoparser.HtmlAutoOpenElement;
import karate.org.attoparser.HtmlBodyAutoCloseElement;
import karate.org.attoparser.HtmlBodyBlockElement;
import karate.org.attoparser.HtmlBodyElement;
import karate.org.attoparser.HtmlElement;
import karate.org.attoparser.HtmlHeadCDATAContentElement;
import karate.org.attoparser.HtmlHeadElement;
import karate.org.attoparser.HtmlVoidAutoOpenCloseElement;
import karate.org.attoparser.HtmlVoidBodyBlockElement;
import karate.org.attoparser.HtmlVoidBodyElement;
import karate.org.attoparser.HtmlVoidHeadElement;
import karate.org.attoparser.util.TextUtil;

final class HtmlElements {
    private static final HtmlElementRepository ELEMENTS = new HtmlElementRepository();
    static final Set<HtmlElement> ALL_STANDARD_ELEMENTS;
    static final HtmlElement HTML;
    static final HtmlElement HEAD;
    static final HtmlElement TITLE;
    static final HtmlElement BASE;
    static final HtmlElement LINK;
    static final HtmlElement META;
    static final HtmlElement STYLE;
    static final HtmlElement SCRIPT;
    static final HtmlElement NOSCRIPT;
    static final HtmlElement BODY;
    static final HtmlElement ARTICLE;
    static final HtmlElement SECTION;
    static final HtmlElement NAV;
    static final HtmlElement ASIDE;
    static final HtmlElement H1;
    static final HtmlElement H2;
    static final HtmlElement H3;
    static final HtmlElement H4;
    static final HtmlElement H5;
    static final HtmlElement H6;
    static final HtmlElement HGROUP;
    static final HtmlElement HEADER;
    static final HtmlElement FOOTER;
    static final HtmlElement ADDRESS;
    static final HtmlElement MAIN;
    static final HtmlElement P;
    static final HtmlElement HR;
    static final HtmlElement PRE;
    static final HtmlElement BLOCKQUOTE;
    static final HtmlElement OL;
    static final HtmlElement UL;
    static final HtmlElement LI;
    static final HtmlElement DL;
    static final HtmlElement DT;
    static final HtmlElement DD;
    static final HtmlElement FIGURE;
    static final HtmlElement FIGCAPTION;
    static final HtmlElement DIV;
    static final HtmlElement A;
    static final HtmlElement EM;
    static final HtmlElement STRONG;
    static final HtmlElement SMALL;
    static final HtmlElement S;
    static final HtmlElement CITE;
    static final HtmlElement G;
    static final HtmlElement DFN;
    static final HtmlElement ABBR;
    static final HtmlElement TIME;
    static final HtmlElement CODE;
    static final HtmlElement VAR;
    static final HtmlElement SAMP;
    static final HtmlElement KBD;
    static final HtmlElement SUB;
    static final HtmlElement SUP;
    static final HtmlElement I;
    static final HtmlElement B;
    static final HtmlElement U;
    static final HtmlElement MARK;
    static final HtmlElement RUBY;
    static final HtmlElement RB;
    static final HtmlElement RT;
    static final HtmlElement RTC;
    static final HtmlElement RP;
    static final HtmlElement BDI;
    static final HtmlElement BDO;
    static final HtmlElement SPAN;
    static final HtmlElement BR;
    static final HtmlElement WBR;
    static final HtmlElement INS;
    static final HtmlElement DEL;
    static final HtmlElement IMG;
    static final HtmlElement IFRAME;
    static final HtmlElement EMBED;
    static final HtmlElement OBJECT;
    static final HtmlElement PARAM;
    static final HtmlElement VIDEO;
    static final HtmlElement AUDIO;
    static final HtmlElement SOURCE;
    static final HtmlElement TRACK;
    static final HtmlElement CANVAS;
    static final HtmlElement MAP;
    static final HtmlElement AREA;
    static final HtmlElement TABLE;
    static final HtmlElement CAPTION;
    static final HtmlElement COLGROUP;
    static final HtmlElement COL;
    static final HtmlElement TBODY;
    static final HtmlElement THEAD;
    static final HtmlElement TFOOT;
    static final HtmlElement TR;
    static final HtmlElement TD;
    static final HtmlElement TH;
    static final HtmlElement FORM;
    static final HtmlElement FIELDSET;
    static final HtmlElement LEGEND;
    static final HtmlElement LABEL;
    static final HtmlElement INPUT;
    static final HtmlElement BUTTON;
    static final HtmlElement SELECT;
    static final HtmlElement DATALIST;
    static final HtmlElement OPTGROUP;
    static final HtmlElement OPTION;
    static final HtmlElement TEXTAREA;
    static final HtmlElement KEYGEN;
    static final HtmlElement OUTPUT;
    static final HtmlElement PROGRESS;
    static final HtmlElement METER;
    static final HtmlElement DETAILS;
    static final HtmlElement SUMMARY;
    static final HtmlElement COMMAND;
    static final HtmlElement MENU;
    static final HtmlElement MENUITEM;
    static final HtmlElement DIALOG;
    static final HtmlElement TEMPLATE;
    static final HtmlElement ELEMENT;
    static final HtmlElement DECORATOR;
    static final HtmlElement CONTENT;
    static final HtmlElement SHADOW;

    static HtmlElement forName(char[] elementNameBuffer, int offset, int len) {
        if (elementNameBuffer == null) {
            throw new IllegalArgumentException("Buffer cannot be null");
        }
        return ELEMENTS.getElement(elementNameBuffer, offset, len);
    }

    private HtmlElements() {
    }

    static {
        HTML = new HtmlElement("html");
        HEAD = new HtmlAutoOpenElement("head", new String[]{"html"}, null);
        TITLE = new HtmlHeadElement("title");
        BASE = new HtmlVoidHeadElement("base");
        LINK = new HtmlVoidHeadElement("link");
        META = new HtmlVoidHeadElement("meta");
        STYLE = new HtmlHeadCDATAContentElement("style");
        SCRIPT = new HtmlHeadCDATAContentElement("script");
        NOSCRIPT = new HtmlHeadElement("noscript");
        BODY = new HtmlAutoOpenCloseElement("body", new String[]{"html"}, null, new String[]{"head"}, null);
        ARTICLE = new HtmlBodyBlockElement("article");
        SECTION = new HtmlBodyBlockElement("section");
        NAV = new HtmlBodyBlockElement("nav");
        ASIDE = new HtmlBodyBlockElement("aside");
        H1 = new HtmlBodyBlockElement("h1");
        H2 = new HtmlBodyBlockElement("h2");
        H3 = new HtmlBodyBlockElement("h3");
        H4 = new HtmlBodyBlockElement("h4");
        H5 = new HtmlBodyBlockElement("h5");
        H6 = new HtmlBodyBlockElement("h6");
        HGROUP = new HtmlBodyBlockElement("hgroup");
        HEADER = new HtmlBodyBlockElement("header");
        FOOTER = new HtmlBodyBlockElement("footer");
        ADDRESS = new HtmlBodyBlockElement("address");
        MAIN = new HtmlBodyBlockElement("main");
        P = new HtmlBodyBlockElement("p");
        HR = new HtmlVoidBodyBlockElement("hr");
        PRE = new HtmlBodyBlockElement("pre");
        BLOCKQUOTE = new HtmlBodyBlockElement("blockquote");
        OL = new HtmlBodyBlockElement("ol");
        UL = new HtmlBodyBlockElement("ul");
        LI = new HtmlBodyAutoCloseElement("li", new String[]{"li"}, new String[]{"ul", "ol"});
        DL = new HtmlBodyBlockElement("dl");
        DT = new HtmlBodyAutoCloseElement("dt", new String[]{"dt", "dd"}, new String[]{"dl"});
        DD = new HtmlBodyAutoCloseElement("dd", new String[]{"dt", "dd"}, new String[]{"dl"});
        FIGURE = new HtmlBodyElement("figure");
        FIGCAPTION = new HtmlBodyElement("figcaption");
        DIV = new HtmlBodyBlockElement("div");
        A = new HtmlBodyElement("a");
        EM = new HtmlBodyElement("em");
        STRONG = new HtmlBodyElement("strong");
        SMALL = new HtmlBodyElement("small");
        S = new HtmlBodyElement("s");
        CITE = new HtmlBodyElement("cite");
        G = new HtmlBodyElement("g");
        DFN = new HtmlBodyElement("dfn");
        ABBR = new HtmlBodyElement("abbr");
        TIME = new HtmlBodyElement("time");
        CODE = new HtmlBodyElement("code");
        VAR = new HtmlBodyElement("var");
        SAMP = new HtmlBodyElement("samp");
        KBD = new HtmlBodyElement("kbd");
        SUB = new HtmlBodyElement("sub");
        SUP = new HtmlBodyElement("sup");
        I = new HtmlBodyElement("i");
        B = new HtmlBodyElement("b");
        U = new HtmlBodyElement("u");
        MARK = new HtmlBodyElement("mark");
        RUBY = new HtmlBodyElement("ruby");
        RB = new HtmlBodyAutoCloseElement("rb", new String[]{"rb", "rt", "rtc", "rp"}, new String[]{"ruby"});
        RT = new HtmlBodyAutoCloseElement("rt", new String[]{"rb", "rt", "rp"}, new String[]{"ruby", "rtc"});
        RTC = new HtmlBodyAutoCloseElement("rtc", new String[]{"rb", "rt", "rtc", "rp"}, new String[]{"ruby"});
        RP = new HtmlBodyAutoCloseElement("rp", new String[]{"rb", "rt", "rp"}, new String[]{"ruby", "rtc"});
        BDI = new HtmlBodyElement("bdi");
        BDO = new HtmlBodyElement("bdo");
        SPAN = new HtmlBodyElement("span");
        BR = new HtmlVoidBodyElement("br");
        WBR = new HtmlVoidBodyElement("wbr");
        INS = new HtmlBodyElement("ins");
        DEL = new HtmlBodyElement("del");
        IMG = new HtmlVoidBodyElement("img");
        IFRAME = new HtmlBodyElement("iframe");
        EMBED = new HtmlVoidBodyElement("embed");
        OBJECT = new HtmlHeadElement("object");
        PARAM = new HtmlVoidBodyElement("param");
        VIDEO = new HtmlBodyElement("video");
        AUDIO = new HtmlBodyElement("audio");
        SOURCE = new HtmlVoidBodyElement("source");
        TRACK = new HtmlVoidBodyElement("track");
        CANVAS = new HtmlBodyElement("canvas");
        MAP = new HtmlBodyElement("map");
        AREA = new HtmlVoidBodyElement("area");
        TABLE = new HtmlBodyBlockElement("table");
        CAPTION = new HtmlBodyAutoCloseElement("caption", new String[]{"tr", "td", "th", "thead", "tfoot", "tbody", "caption", "colgroup"}, new String[]{"table"});
        COLGROUP = new HtmlBodyAutoCloseElement("colgroup", new String[]{"tr", "td", "th", "thead", "tfoot", "tbody", "caption", "colgroup"}, new String[]{"table"});
        COL = new HtmlVoidAutoOpenCloseElement("col", new String[]{"colgroup"}, new String[]{"colgroup"}, new String[]{"tr", "td", "th", "thead", "tfoot", "tbody", "caption"}, new String[]{"table"});
        TBODY = new HtmlBodyAutoCloseElement("tbody", new String[]{"tr", "td", "th", "thead", "tfoot", "tbody", "caption", "colgroup"}, new String[]{"table"});
        THEAD = new HtmlBodyAutoCloseElement("thead", new String[]{"tr", "td", "th", "thead", "tfoot", "tbody", "caption", "colgroup"}, new String[]{"table"});
        TFOOT = new HtmlBodyAutoCloseElement("tfoot", new String[]{"tr", "td", "th", "thead", "tfoot", "tbody", "caption", "colgroup"}, new String[]{"table"});
        TR = new HtmlAutoOpenCloseElement("tr", new String[]{"tbody"}, new String[]{"thead", "tfoot", "tbody"}, new String[]{"tr", "td", "th", "caption", "colgroup"}, new String[]{"table", "thead", "tbody", "tfoot"});
        TD = new HtmlBodyAutoCloseElement("td", new String[]{"td", "th"}, new String[]{"tr"});
        TH = new HtmlBodyAutoCloseElement("th", new String[]{"td", "th"}, new String[]{"tr"});
        FORM = new HtmlBodyBlockElement("form");
        FIELDSET = new HtmlBodyBlockElement("fieldset");
        LEGEND = new HtmlBodyElement("legend");
        LABEL = new HtmlBodyElement("label");
        INPUT = new HtmlVoidBodyElement("input");
        BUTTON = new HtmlBodyElement("button");
        SELECT = new HtmlBodyElement("select");
        DATALIST = new HtmlBodyElement("datalist");
        OPTGROUP = new HtmlBodyAutoCloseElement("optgroup", new String[]{"optgroup", "option"}, new String[]{"select"});
        OPTION = new HtmlBodyAutoCloseElement("option", new String[]{"option"}, new String[]{"select", "optgroup", "datalist"});
        TEXTAREA = new HtmlBodyElement("textarea");
        KEYGEN = new HtmlVoidBodyElement("keygen");
        OUTPUT = new HtmlBodyElement("output");
        PROGRESS = new HtmlBodyElement("progress");
        METER = new HtmlBodyElement("meter");
        DETAILS = new HtmlBodyElement("details");
        SUMMARY = new HtmlBodyElement("summary");
        COMMAND = new HtmlBodyElement("command");
        MENU = new HtmlBodyBlockElement("menu");
        MENUITEM = new HtmlVoidBodyElement("menuitem");
        DIALOG = new HtmlBodyElement("dialog");
        TEMPLATE = new HtmlHeadElement("template");
        ELEMENT = new HtmlHeadElement("element");
        DECORATOR = new HtmlHeadElement("decorator");
        CONTENT = new HtmlHeadElement("content");
        SHADOW = new HtmlHeadElement("shadow");
        ALL_STANDARD_ELEMENTS = Collections.unmodifiableSet(new LinkedHashSet<HtmlElement>(Arrays.asList(HTML, HEAD, TITLE, BASE, LINK, META, STYLE, SCRIPT, NOSCRIPT, BODY, ARTICLE, SECTION, NAV, ASIDE, H1, H2, H3, H4, H5, H6, HGROUP, HEADER, FOOTER, ADDRESS, P, HR, PRE, BLOCKQUOTE, OL, UL, LI, DL, DT, DD, FIGURE, FIGCAPTION, DIV, A, EM, STRONG, SMALL, S, CITE, G, DFN, ABBR, TIME, CODE, VAR, SAMP, KBD, SUB, SUP, I, B, U, MARK, RUBY, RB, RT, RTC, RP, BDI, BDO, SPAN, BR, WBR, INS, DEL, IMG, IFRAME, EMBED, OBJECT, PARAM, VIDEO, AUDIO, SOURCE, TRACK, CANVAS, MAP, AREA, TABLE, CAPTION, COLGROUP, COL, TBODY, THEAD, TFOOT, TR, TD, TH, FORM, FIELDSET, LEGEND, LABEL, INPUT, BUTTON, SELECT, DATALIST, OPTGROUP, OPTION, TEXTAREA, KEYGEN, OUTPUT, PROGRESS, METER, DETAILS, SUMMARY, COMMAND, MENU, MENUITEM, DIALOG, MAIN, TEMPLATE, ELEMENT, DECORATOR, CONTENT, SHADOW)));
        for (HtmlElement element : ALL_STANDARD_ELEMENTS) {
            HtmlElements.ELEMENTS.storeStandardElement(element);
        }
    }

    static final class HtmlElementRepository {
        private final List<HtmlElement> standardRepository;
        private final List<HtmlElement> repository;
        private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
        private final Lock readLock = this.lock.readLock();
        private final Lock writeLock = this.lock.writeLock();

        HtmlElementRepository() {
            this.standardRepository = new ArrayList<HtmlElement>(150);
            this.repository = new ArrayList<HtmlElement>(150);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HtmlElement getElement(char[] text, int offset, int len) {
            int index = HtmlElementRepository.binarySearch(this.standardRepository, text, offset, len);
            if (index >= 0) {
                return this.standardRepository.get(index);
            }
            this.readLock.lock();
            try {
                index = HtmlElementRepository.binarySearch(this.repository, text, offset, len);
                if (index >= 0) {
                    HtmlElement htmlElement = this.repository.get(index);
                    return htmlElement;
                }
            }
            finally {
                this.readLock.unlock();
            }
            this.writeLock.lock();
            try {
                HtmlElement htmlElement = this.storeElement(text, offset, len);
                return htmlElement;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        private HtmlElement storeElement(char[] text, int offset, int len) {
            int index = HtmlElementRepository.binarySearch(this.repository, text, offset, len);
            if (index >= 0) {
                return this.repository.get(index);
            }
            HtmlElement element = new HtmlElement(new String(text, offset, len).toLowerCase());
            this.repository.add((index + 1) * -1, element);
            return element;
        }

        private HtmlElement storeStandardElement(HtmlElement element) {
            this.standardRepository.add(element);
            this.repository.add(element);
            Collections.sort(this.standardRepository, ElementComparator.INSTANCE);
            Collections.sort(this.repository, ElementComparator.INSTANCE);
            return element;
        }

        private static int binarySearch(List<HtmlElement> values, char[] text, int offset, int len) {
            int low = 0;
            int high = values.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                char[] midVal = values.get((int)mid).name;
                int cmp = TextUtil.compareTo(false, midVal, 0, midVal.length, text, offset, len);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        private static class ElementComparator
        implements Comparator<HtmlElement> {
            private static ElementComparator INSTANCE = new ElementComparator();

            private ElementComparator() {
            }

            @Override
            public int compare(HtmlElement o1, HtmlElement o2) {
                return TextUtil.compareTo(false, o1.name, o2.name);
            }
        }
    }
}

