/*
 * Decompiled with CFR 0.152.
 */
package karate.org.attoparser;

import karate.org.attoparser.HtmlVoidAutoCloseElement;
import karate.org.attoparser.IMarkupHandler;
import karate.org.attoparser.ParseException;
import karate.org.attoparser.ParseStatus;

class HtmlVoidAutoOpenCloseElement
extends HtmlVoidAutoCloseElement {
    private final char[][] autoOpenParents;
    private final char[][] autoOpenLimits;

    HtmlVoidAutoOpenCloseElement(String name, String[] autoOpenParents, String[] autoOpenLimits, String[] autoCloseElements, String[] autoCloseLimits) {
        super(name, autoCloseElements, autoCloseLimits);
        Object autoOpenLimitsCharArray;
        if (autoOpenParents == null) {
            throw new IllegalArgumentException("The array of auto-open parents cannot be null");
        }
        char[][] autoOpenParentsCharArray = new char[autoOpenParents.length][];
        for (int i = 0; i < autoOpenParentsCharArray.length; ++i) {
            autoOpenParentsCharArray[i] = autoOpenParents[i].toCharArray();
        }
        if (autoOpenLimits != null) {
            autoOpenLimitsCharArray = new char[autoOpenLimits.length][];
            for (int i = 0; i < ((char[][])autoOpenLimitsCharArray).length; ++i) {
                autoOpenLimitsCharArray[i] = autoOpenLimits[i].toCharArray();
            }
        } else {
            autoOpenLimitsCharArray = null;
        }
        this.autoOpenParents = autoOpenParentsCharArray;
        this.autoOpenLimits = autoOpenLimitsCharArray;
    }

    @Override
    public void handleOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col, IMarkupHandler handler, ParseStatus status, boolean autoOpenEnabled, boolean autoCloseEnabled) throws ParseException {
        status.setAvoidStacking(true);
        if ((autoOpenEnabled || autoCloseEnabled) && !status.isAutoOpenCloseDone()) {
            if (autoCloseEnabled) {
                status.setAutoCloseRequired(this.autoCloseRequired, this.autoCloseLimits);
            }
            if (autoOpenEnabled) {
                status.setAutoOpenRequired(this.autoOpenParents, this.autoOpenLimits);
            }
            return;
        }
        handler.handleStandaloneElementStart(buffer, nameOffset, nameLen, false, line, col);
    }

    @Override
    public void handleStandaloneElementStart(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col, IMarkupHandler handler, ParseStatus status, boolean autoOpenEnabled, boolean autoCloseEnabled) throws ParseException {
        status.setAvoidStacking(true);
        if ((autoOpenEnabled || autoCloseEnabled) && !status.isAutoOpenCloseDone()) {
            if (autoCloseEnabled) {
                status.setAutoCloseRequired(this.autoCloseRequired, this.autoCloseLimits);
            }
            if (autoOpenEnabled) {
                status.setAutoOpenRequired(this.autoOpenParents, this.autoOpenLimits);
            }
            return;
        }
        handler.handleStandaloneElementStart(buffer, nameOffset, nameLen, minimized, line, col);
    }
}

