/*
 * Decompiled with CFR 0.152.
 */
package karate.org.attoparser;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import karate.org.attoparser.HtmlMarkupHandler;
import karate.org.attoparser.IMarkupHandler;
import karate.org.attoparser.IMarkupParser;
import karate.org.attoparser.MarkupEventProcessorHandler;
import karate.org.attoparser.ParseException;
import karate.org.attoparser.ParseStatus;
import karate.org.attoparser.ParsingCDATASectionMarkupUtil;
import karate.org.attoparser.ParsingCommentMarkupUtil;
import karate.org.attoparser.ParsingDocTypeMarkupUtil;
import karate.org.attoparser.ParsingElementMarkupUtil;
import karate.org.attoparser.ParsingLocatorUtil;
import karate.org.attoparser.ParsingMarkupUtil;
import karate.org.attoparser.ParsingProcessingInstructionUtil;
import karate.org.attoparser.ParsingXmlDeclarationMarkupUtil;
import karate.org.attoparser.config.ParseConfiguration;
import karate.org.attoparser.select.ParseSelection;

public final class MarkupParser
implements IMarkupParser {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int DEFAULT_POOL_SIZE = 2;
    private final ParseConfiguration configuration;
    private final BufferPool pool;

    public MarkupParser(ParseConfiguration configuration) {
        this(configuration, 2, 4096);
    }

    public MarkupParser(ParseConfiguration configuration, int poolSize, int bufferSize) {
        this.configuration = configuration;
        this.pool = new BufferPool(poolSize, bufferSize);
    }

    @Override
    public void parse(String document, IMarkupHandler handler) throws ParseException {
        if (document == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
        this.parse(new StringReader(document), handler);
    }

    @Override
    public void parse(char[] document, IMarkupHandler handler) throws ParseException {
        if (document == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
        this.parse(document, 0, document.length, handler);
    }

    @Override
    public void parse(char[] document, int offset, int len, IMarkupHandler handler) throws ParseException {
        if (document == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
        if (offset < 0 || len < 0) {
            throw new IllegalArgumentException("Neither document offset (" + offset + ") nor document length (" + len + ") can be less than zero");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        IMarkupHandler markupHandler = ParseConfiguration.ParsingMode.HTML.equals((Object)this.configuration.getMode()) ? new HtmlMarkupHandler(handler) : handler;
        markupHandler = new MarkupEventProcessorHandler(markupHandler);
        markupHandler.setParseConfiguration(this.configuration);
        ParseStatus status = new ParseStatus();
        markupHandler.setParseStatus(status);
        ParseSelection selection = new ParseSelection();
        markupHandler.setParseSelection(selection);
        this.parseDocument(document, offset, len, markupHandler, status);
    }

    @Override
    public void parse(Reader reader, IMarkupHandler handler) throws ParseException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader cannot be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        IMarkupHandler markupHandler = ParseConfiguration.ParsingMode.HTML.equals((Object)this.configuration.getMode()) ? new HtmlMarkupHandler(handler) : handler;
        markupHandler = new MarkupEventProcessorHandler(markupHandler);
        markupHandler.setParseConfiguration(this.configuration);
        ParseStatus status = new ParseStatus();
        markupHandler.setParseStatus(status);
        ParseSelection selection = new ParseSelection();
        markupHandler.setParseSelection(selection);
        this.parseDocument(reader, this.pool.poolBufferSize, markupHandler, status);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parseDocument(Reader reader, int suggestedBufferSize, IMarkupHandler handler, ParseStatus status) throws ParseException {
        long parsingStartTimeNanos = System.nanoTime();
        char[] buffer = null;
        try {
            handler.handleDocumentStart(parsingStartTimeNanos, 1, 1);
            int bufferSize2333332 = suggestedBufferSize;
            buffer = this.pool.allocateBuffer(bufferSize2333332);
            int bufferContentSize = reader.read(buffer);
            boolean cont = bufferContentSize != -1;
            status.offset = -1;
            status.line = 1;
            status.col = 1;
            status.inStructure = false;
            status.parsingDisabled = true;
            status.parsingDisabledLimitSequence = null;
            status.autoCloseRequired = null;
            status.autoCloseLimits = null;
            while (cont) {
                this.parseBuffer(buffer, 0, bufferContentSize, handler, status);
                int readOffset = 0;
                int readLen = bufferSize2333332;
                if (status.offset == 0) {
                    if (bufferContentSize == bufferSize2333332) {
                        char[] newBuffer = null;
                        try {
                            newBuffer = this.pool.allocateBuffer(bufferSize2333332 *= 2);
                            System.arraycopy(buffer, 0, newBuffer, 0, bufferContentSize);
                            this.pool.releaseBuffer(buffer);
                            buffer = newBuffer;
                        }
                        catch (Exception ignored) {
                            this.pool.releaseBuffer(newBuffer);
                        }
                    }
                    readOffset = bufferContentSize;
                    readLen = bufferSize2333332 - readOffset;
                } else if (status.offset < bufferContentSize) {
                    System.arraycopy(buffer, status.offset, buffer, 0, bufferContentSize - status.offset);
                    readOffset = bufferContentSize - status.offset;
                    readLen = bufferSize2333332 - readOffset;
                    status.offset = 0;
                    bufferContentSize = readOffset;
                }
                int read = reader.read(buffer, readOffset, readLen);
                if (read != -1) {
                    bufferContentSize = readOffset + read;
                    continue;
                }
                cont = false;
            }
            int lastLine = status.line;
            int lastCol = status.col;
            int lastStart = status.offset;
            int lastLen = bufferContentSize - lastStart;
            if (lastLen > 0) {
                if (status.inStructure) {
                    throw new ParseException("Incomplete structure: \"" + new String(buffer, lastStart, lastLen) + "\"", status.line, status.col);
                }
                handler.handleText(buffer, lastStart, lastLen, status.line, status.col);
                for (int i = lastStart; i < lastStart + lastLen; ++i) {
                    char c = buffer[i];
                    if (c == '\n') {
                        ++lastLine;
                        lastCol = 1;
                        continue;
                    }
                    ++lastCol;
                }
            }
            long parsingEndTimeNanos = System.nanoTime();
            handler.handleDocumentEnd(parsingEndTimeNanos, parsingEndTimeNanos - parsingStartTimeNanos, lastLine, lastCol);
        }
        catch (ParseException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new ParseException(e2);
                }
            }
            catch (Throwable throwable) {
                this.pool.releaseBuffer(buffer);
                try {
                    reader.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.pool.releaseBuffer(buffer);
        try {
            reader.close();
            return;
        }
        catch (Throwable bufferSize2333332) {
            return;
        }
    }

    void parseDocument(char[] buffer, int offset, int len, IMarkupHandler handler, ParseStatus status) throws ParseException {
        long parsingStartTimeNanos = System.nanoTime();
        try {
            handler.handleDocumentStart(parsingStartTimeNanos, 1, 1);
            status.offset = -1;
            status.line = 1;
            status.col = 1;
            status.inStructure = false;
            status.parsingDisabled = true;
            status.parsingDisabledLimitSequence = null;
            status.autoCloseRequired = null;
            status.autoCloseLimits = null;
            this.parseBuffer(buffer, offset, len, handler, status);
            int lastLine = status.line;
            int lastCol = status.col;
            int lastStart = status.offset;
            int lastLen = offset + len - lastStart;
            if (lastLen > 0) {
                if (status.inStructure) {
                    throw new ParseException("Incomplete structure: \"" + new String(buffer, lastStart, lastLen) + "\"", status.line, status.col);
                }
                handler.handleText(buffer, lastStart, lastLen, status.line, status.col);
                for (int i = lastStart; i < lastStart + lastLen; ++i) {
                    char c = buffer[i];
                    if (c == '\n') {
                        ++lastLine;
                        lastCol = 1;
                        continue;
                    }
                    ++lastCol;
                }
            }
            long parsingEndTimeNanos = System.nanoTime();
            handler.handleDocumentEnd(parsingEndTimeNanos, parsingEndTimeNanos - parsingStartTimeNanos, lastLine, lastCol);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    private void parseBuffer(char[] buffer, int offset, int len, IMarkupHandler handler, ParseStatus status) throws ParseException {
        int i;
        int[] locator = new int[]{status.line, status.col};
        int maxi = offset + len;
        int current = i = offset;
        boolean inOpenElement = false;
        boolean inCloseElement = false;
        boolean inComment = false;
        boolean inCdata = false;
        boolean inDocType = false;
        boolean inXmlDeclaration = false;
        boolean inProcessingInstruction = false;
        while (i < maxi) {
            int tagEnd;
            boolean avoidQuotes;
            boolean inStructure;
            int currentLine = locator[0];
            int currentCol = locator[1];
            if (status.parsingDisabledLimitSequence != null) {
                int sequenceIndex = ParsingMarkupUtil.findCharacterSequence(buffer, i, maxi, locator, status.parsingDisabledLimitSequence);
                if (sequenceIndex == -1) {
                    if (this.configuration.isTextSplittable()) {
                        handler.handleText(buffer, current, len - current, currentLine, currentCol);
                        current = len;
                    }
                    status.offset = current;
                    status.line = currentLine;
                    status.col = currentCol;
                    status.inStructure = false;
                    return;
                }
                handler.handleText(buffer, current, sequenceIndex - current, currentLine, currentCol);
                status.parsingDisabledLimitSequence = null;
                status.parsingDisabled = true;
                i = current = sequenceIndex;
            }
            boolean bl = inStructure = inOpenElement || inCloseElement || inComment || inCdata || inDocType || inXmlDeclaration || inProcessingInstruction;
            if (!inStructure) {
                int tagStart = ParsingMarkupUtil.findNextStructureStart(buffer, i, maxi, locator);
                if (tagStart == -1) {
                    if (this.configuration.isTextSplittable()) {
                        handler.handleText(buffer, current, len - current, currentLine, currentCol);
                        if (status.parsingDisabledLimitSequence != null) {
                            status.parsingDisabled = false;
                        }
                        current = len;
                    }
                    status.offset = current;
                    status.line = currentLine;
                    status.col = currentCol;
                    status.inStructure = false;
                    return;
                }
                inOpenElement = ParsingElementMarkupUtil.isOpenElementStart(buffer, tagStart, maxi);
                if (!(inOpenElement || (inCloseElement = ParsingElementMarkupUtil.isCloseElementStart(buffer, tagStart, maxi)) || (inComment = ParsingCommentMarkupUtil.isCommentStart(buffer, tagStart, maxi)) || (inCdata = ParsingCDATASectionMarkupUtil.isCDATASectionStart(buffer, tagStart, maxi)) || (inDocType = ParsingDocTypeMarkupUtil.isDocTypeStart(buffer, tagStart, maxi)) || (inXmlDeclaration = ParsingXmlDeclarationMarkupUtil.isXmlDeclarationStart(buffer, tagStart, maxi)))) {
                    inProcessingInstruction = ParsingProcessingInstructionUtil.isProcessingInstructionStart(buffer, tagStart, maxi);
                }
                boolean bl2 = inStructure = inOpenElement || inCloseElement || inComment || inCdata || inDocType || inXmlDeclaration || inProcessingInstruction;
                while (!inStructure) {
                    ParsingLocatorUtil.countChar(locator, buffer[tagStart]);
                    tagStart = ParsingMarkupUtil.findNextStructureStart(buffer, tagStart + 1, maxi, locator);
                    if (tagStart == -1) {
                        status.offset = current;
                        status.line = currentLine;
                        status.col = currentCol;
                        status.inStructure = false;
                        return;
                    }
                    inOpenElement = ParsingElementMarkupUtil.isOpenElementStart(buffer, tagStart, maxi);
                    if (!(inOpenElement || (inCloseElement = ParsingElementMarkupUtil.isCloseElementStart(buffer, tagStart, maxi)) || (inComment = ParsingCommentMarkupUtil.isCommentStart(buffer, tagStart, maxi)) || (inCdata = ParsingCDATASectionMarkupUtil.isCDATASectionStart(buffer, tagStart, maxi)) || (inDocType = ParsingDocTypeMarkupUtil.isDocTypeStart(buffer, tagStart, maxi)) || (inXmlDeclaration = ParsingXmlDeclarationMarkupUtil.isXmlDeclarationStart(buffer, tagStart, maxi)))) {
                        inProcessingInstruction = ParsingProcessingInstructionUtil.isProcessingInstructionStart(buffer, tagStart, maxi);
                    }
                    inStructure = inOpenElement || inCloseElement || inComment || inCdata || inDocType || inXmlDeclaration || inProcessingInstruction;
                }
                if (tagStart > current) {
                    handler.handleText(buffer, current, tagStart - current, currentLine, currentCol);
                    if (status.parsingDisabledLimitSequence != null) {
                        status.parsingDisabled = false;
                    }
                }
                i = current = tagStart;
                continue;
            }
            boolean bl3 = avoidQuotes = inOpenElement || inCloseElement || inDocType || inXmlDeclaration;
            int n = inDocType ? ParsingDocTypeMarkupUtil.findNextDocTypeStructureEnd(buffer, i, maxi, locator) : (tagEnd = avoidQuotes ? ParsingMarkupUtil.findNextStructureEndAvoidQuotes(buffer, i, maxi, locator) : ParsingMarkupUtil.findNextStructureEndDontAvoidQuotes(buffer, i, maxi, locator));
            if (tagEnd < 0) {
                status.offset = current;
                status.line = currentLine;
                status.col = currentCol;
                status.inStructure = true;
                return;
            }
            if (inOpenElement) {
                if (buffer[tagEnd - 1] == '/') {
                    ParsingElementMarkupUtil.parseStandaloneElement(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler);
                } else {
                    ParsingElementMarkupUtil.parseOpenElement(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler);
                }
                if (status.parsingDisabledLimitSequence != null) {
                    status.parsingDisabled = false;
                }
                inOpenElement = false;
            } else if (inCloseElement) {
                ParsingElementMarkupUtil.parseCloseElement(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler);
                if (status.parsingDisabledLimitSequence != null) {
                    status.parsingDisabled = false;
                }
                inCloseElement = false;
            } else if (inComment) {
                while (tagEnd - current < 6 || buffer[tagEnd - 1] != '-' || buffer[tagEnd - 2] != '-') {
                    ParsingLocatorUtil.countChar(locator, buffer[tagEnd]);
                    if ((tagEnd = ParsingMarkupUtil.findNextStructureEndDontAvoidQuotes(buffer, tagEnd + 1, maxi, locator)) != -1) continue;
                    status.offset = current;
                    status.line = currentLine;
                    status.col = currentCol;
                    status.inStructure = true;
                    return;
                }
                ParsingCommentMarkupUtil.parseComment(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler);
                if (status.parsingDisabledLimitSequence != null) {
                    status.parsingDisabled = false;
                }
                inComment = false;
            } else if (inCdata) {
                while (tagEnd - current < 11 || buffer[tagEnd - 1] != ']' || buffer[tagEnd - 2] != ']') {
                    ParsingLocatorUtil.countChar(locator, buffer[tagEnd]);
                    if ((tagEnd = ParsingMarkupUtil.findNextStructureEndDontAvoidQuotes(buffer, tagEnd + 1, maxi, locator)) != -1) continue;
                    status.offset = current;
                    status.line = currentLine;
                    status.col = currentCol;
                    status.inStructure = true;
                    return;
                }
                ParsingCDATASectionMarkupUtil.parseCDATASection(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler);
                if (status.parsingDisabledLimitSequence != null) {
                    status.parsingDisabled = false;
                }
                inCdata = false;
            } else if (inDocType) {
                ParsingDocTypeMarkupUtil.parseDocType(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler);
                if (status.parsingDisabledLimitSequence != null) {
                    status.parsingDisabled = false;
                }
                inDocType = false;
            } else if (inXmlDeclaration) {
                ParsingXmlDeclarationMarkupUtil.parseXmlDeclaration(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler);
                if (status.parsingDisabledLimitSequence != null) {
                    status.parsingDisabled = false;
                }
                inXmlDeclaration = false;
            } else if (inProcessingInstruction) {
                while (tagEnd - current < 5 || buffer[tagEnd - 1] != '?') {
                    ParsingLocatorUtil.countChar(locator, buffer[tagEnd]);
                    if ((tagEnd = ParsingMarkupUtil.findNextStructureEndDontAvoidQuotes(buffer, tagEnd + 1, maxi, locator)) != -1) continue;
                    status.offset = current;
                    status.line = currentLine;
                    status.col = currentCol;
                    status.inStructure = true;
                    return;
                }
                ParsingProcessingInstructionUtil.parseProcessingInstruction(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler);
                if (status.parsingDisabledLimitSequence != null) {
                    status.parsingDisabled = false;
                }
                inProcessingInstruction = false;
            } else {
                throw new IllegalStateException("Illegal parsing state: structure is not of a recognized type");
            }
            ParsingLocatorUtil.countChar(locator, buffer[tagEnd]);
            i = current = tagEnd + 1;
        }
        status.offset = current;
        status.line = locator[0];
        status.col = locator[1];
        status.inStructure = false;
    }

    private static final class BufferPool {
        private final char[][] pool;
        private final boolean[] allocated;
        private final int poolBufferSize;

        private BufferPool(int poolSize, int poolBufferSize) {
            this.pool = new char[poolSize][];
            this.allocated = new boolean[poolSize];
            this.poolBufferSize = poolBufferSize;
            for (int i = 0; i < this.pool.length; ++i) {
                this.pool[i] = new char[this.poolBufferSize];
            }
            Arrays.fill(this.allocated, false);
        }

        private synchronized char[] allocateBuffer(int bufferSize) {
            if (bufferSize != this.poolBufferSize) {
                return new char[bufferSize];
            }
            for (int i = 0; i < this.pool.length; ++i) {
                if (this.allocated[i]) continue;
                this.allocated[i] = true;
                return this.pool[i];
            }
            return new char[bufferSize];
        }

        private synchronized void releaseBuffer(char[] buffer) {
            if (buffer == null) {
                return;
            }
            if (buffer.length != this.poolBufferSize) {
                return;
            }
            for (int i = 0; i < this.pool.length; ++i) {
                if (this.pool[i] != buffer) continue;
                this.allocated[i] = false;
                return;
            }
        }
    }
}

