/*
 * Decompiled with CFR 0.152.
 */
package karate.org.attoparser;

import karate.org.attoparser.IMarkupHandler;
import karate.org.attoparser.ParseException;
import karate.org.attoparser.ParsingAttributeSequenceUtil;
import karate.org.attoparser.ParsingMarkupUtil;

public final class ParsingElementMarkupUtil {
    private ParsingElementMarkupUtil() {
    }

    public static void parseStandaloneElement(char[] buffer, int offset, int len, int line, int col, IMarkupHandler markupHandler) throws ParseException {
        if (len < 4 || !ParsingElementMarkupUtil.isOpenElementStart(buffer, offset, offset + len) || !ParsingElementMarkupUtil.isElementEnd(buffer, offset + len - 2, offset + len, true)) {
            throw new ParseException("Could not parse as a well-formed standalone element: \"" + new String(buffer, offset, len) + "\"", line, col);
        }
        int contentOffset = offset + 1;
        int contentLen = len - 3;
        int maxi = contentOffset + contentLen;
        int[] locator = new int[]{line, col + 1};
        int elementNameEnd = ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, contentOffset, maxi, true, locator);
        if (elementNameEnd == -1) {
            markupHandler.handleStandaloneElementStart(buffer, contentOffset, contentLen, true, line, col);
            markupHandler.handleStandaloneElementEnd(buffer, contentOffset, contentLen, true, locator[0], locator[1]);
            return;
        }
        markupHandler.handleStandaloneElementStart(buffer, contentOffset, elementNameEnd - contentOffset, true, line, col);
        ParsingAttributeSequenceUtil.parseAttributeSequence(buffer, elementNameEnd, maxi - elementNameEnd, locator[0], locator[1], markupHandler);
        ParsingMarkupUtil.findNextStructureEndAvoidQuotes(buffer, elementNameEnd, maxi, locator);
        markupHandler.handleStandaloneElementEnd(buffer, contentOffset, elementNameEnd - contentOffset, true, locator[0], locator[1]);
    }

    public static void parseOpenElement(char[] buffer, int offset, int len, int line, int col, IMarkupHandler markupHandler) throws ParseException {
        if (len < 3 || !ParsingElementMarkupUtil.isOpenElementStart(buffer, offset, offset + len) || !ParsingElementMarkupUtil.isElementEnd(buffer, offset + len - 1, offset + len, false)) {
            throw new ParseException("Could not parse as a well-formed open element: \"" + new String(buffer, offset, len) + "\"", line, col);
        }
        int contentOffset = offset + 1;
        int contentLen = len - 2;
        int maxi = contentOffset + contentLen;
        int[] locator = new int[]{line, col + 1};
        int elementNameEnd = ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, contentOffset, maxi, true, locator);
        if (elementNameEnd == -1) {
            markupHandler.handleOpenElementStart(buffer, contentOffset, contentLen, line, col);
            markupHandler.handleOpenElementEnd(buffer, contentOffset, contentLen, locator[0], locator[1]);
            return;
        }
        markupHandler.handleOpenElementStart(buffer, contentOffset, elementNameEnd - contentOffset, line, col);
        ParsingAttributeSequenceUtil.parseAttributeSequence(buffer, elementNameEnd, maxi - elementNameEnd, locator[0], locator[1], markupHandler);
        ParsingMarkupUtil.findNextStructureEndAvoidQuotes(buffer, elementNameEnd, maxi, locator);
        markupHandler.handleOpenElementEnd(buffer, contentOffset, elementNameEnd - contentOffset, locator[0], locator[1]);
    }

    public static void parseCloseElement(char[] buffer, int offset, int len, int line, int col, IMarkupHandler markupHandler) throws ParseException {
        if (len < 4 || !ParsingElementMarkupUtil.isCloseElementStart(buffer, offset, offset + len) || !ParsingElementMarkupUtil.isElementEnd(buffer, offset + len - 1, offset + len, false)) {
            throw new ParseException("Could not parse as a well-formed close element: \"" + new String(buffer, offset, len) + "\"", line, col);
        }
        int contentOffset = offset + 2;
        int contentLen = len - 3;
        int maxi = contentOffset + contentLen;
        int[] locator = new int[]{line, col + 2};
        int elementNameEnd = ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, contentOffset, maxi, true, locator);
        if (elementNameEnd == -1) {
            markupHandler.handleCloseElementStart(buffer, contentOffset, contentLen, line, col);
            markupHandler.handleCloseElementEnd(buffer, contentOffset, contentLen, locator[0], locator[1]);
            return;
        }
        markupHandler.handleCloseElementStart(buffer, contentOffset, elementNameEnd - contentOffset, line, col);
        int currentArtifactLine = locator[0];
        int currentArtifactCol = locator[1];
        int wsEnd = ParsingMarkupUtil.findNextNonWhitespaceCharWildcard(buffer, elementNameEnd, maxi, locator);
        if (wsEnd != -1) {
            throw new ParseException("Could not parse as a well-formed closing element \"</" + new String(buffer, contentOffset, contentLen) + ">\": No attributes are allowed here", line, col);
        }
        markupHandler.handleInnerWhiteSpace(buffer, elementNameEnd, maxi - elementNameEnd, currentArtifactLine, currentArtifactCol);
        markupHandler.handleCloseElementEnd(buffer, contentOffset, elementNameEnd - contentOffset, locator[0], locator[1]);
    }

    static boolean isOpenElementStart(char[] buffer, int offset, int maxi) {
        int len = maxi - offset;
        return len > 1 && buffer[offset] == '<' && ParsingElementMarkupUtil.isElementName(buffer, offset + 1, maxi);
    }

    static boolean isCloseElementStart(char[] buffer, int offset, int maxi) {
        int len = maxi - offset;
        return len > 2 && buffer[offset] == '<' && buffer[offset + 1] == '/' && ParsingElementMarkupUtil.isElementName(buffer, offset + 2, maxi);
    }

    static boolean isElementEnd(char[] buffer, int offset, int maxi, boolean minimized) {
        int len = maxi - offset;
        if (len < 1) {
            return false;
        }
        if (minimized) {
            if (len < 2 || buffer[offset] != '/') {
                return false;
            }
            return buffer[offset + 1] == '>';
        }
        return buffer[offset] == '>';
    }

    private static boolean isElementName(char[] buffer, int offset, int maxi) {
        int len = maxi - offset;
        if (len > 1 && buffer[offset] == '!') {
            if (len > 8) {
                return buffer[offset + 1] != '-' && buffer[offset + 1] != '!' && buffer[offset + 1] != '/' && buffer[offset + 1] != '?' && buffer[offset + 1] != '[' && (buffer[offset + 1] != 'D' && buffer[offset + 1] != 'd' || buffer[offset + 2] != 'O' && buffer[offset + 2] != 'o' || buffer[offset + 3] != 'C' && buffer[offset + 3] != 'c' || buffer[offset + 4] != 'T' && buffer[offset + 4] != 't' || buffer[offset + 5] != 'Y' && buffer[offset + 5] != 'y' || buffer[offset + 6] != 'P' && buffer[offset + 6] != 'p' || buffer[offset + 7] != 'E' && buffer[offset + 7] != 'e' || !Character.isWhitespace(buffer[offset + 8]) && buffer[offset + 8] != '>');
            }
            return buffer[offset + 1] != '-' && buffer[offset + 1] != '!' && buffer[offset + 1] != '/' && buffer[offset + 1] != '?' && buffer[offset + 1] != '[' && !Character.isWhitespace(buffer[offset + 1]);
        }
        return len > 0 && buffer[offset] != '-' && buffer[offset] != '!' && buffer[offset] != '/' && buffer[offset] != '?' && buffer[offset] != '[' && !Character.isWhitespace(buffer[offset]);
    }
}

