/*
 * Decompiled with CFR 0.152.
 */
package karate.org.attoparser;

import karate.org.attoparser.IProcessingInstructionHandler;
import karate.org.attoparser.ParseException;
import karate.org.attoparser.ParsingMarkupUtil;

public final class ParsingProcessingInstructionUtil {
    private ParsingProcessingInstructionUtil() {
    }

    public static void parseProcessingInstruction(char[] buffer, int offset, int len, int line, int col, IProcessingInstructionHandler handler) throws ParseException {
        if (len < 4 || !ParsingProcessingInstructionUtil.isProcessingInstructionStart(buffer, offset, offset + len) || !ParsingProcessingInstructionUtil.isProcessingInstructionEnd(buffer, offset + len - 2, offset + len)) {
            throw new ParseException("Could not parse as a well-formed Processing Instruction: \"" + new String(buffer, offset, len) + "\"", line, col);
        }
        int contentOffset = offset + 2;
        int i = contentOffset;
        int contentLen = len - 4;
        int maxi = contentOffset + contentLen;
        int[] locator = new int[]{line, col + 2};
        int targetEnd = ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, i, maxi, false, locator);
        if (targetEnd == -1) {
            handler.handleProcessingInstruction(buffer, i, maxi - i, line, col + 2, 0, 0, locator[0], locator[1], offset, len, line, col);
            return;
        }
        int targetOffset = i;
        int targetLen = targetEnd - targetOffset;
        i = targetEnd;
        int contentStart = ParsingMarkupUtil.findNextNonWhitespaceCharWildcard(buffer, i, maxi, locator);
        if (contentStart == -1) {
            handler.handleProcessingInstruction(buffer, targetOffset, targetLen, line, col + 2, 0, 0, locator[0], locator[1], offset, len, line, col);
            return;
        }
        handler.handleProcessingInstruction(buffer, targetOffset, targetLen, line, col + 2, contentStart, maxi - contentStart, locator[0], locator[1], offset, len, line, col);
    }

    static boolean isProcessingInstructionStart(char[] buffer, int offset, int maxi) {
        int len = maxi - offset;
        if (len > 5) {
            return buffer[offset] == '<' && buffer[offset + 1] == '?' && buffer[offset + 2] != ' ' && !Character.isWhitespace(buffer[offset + 2]) && (buffer[offset + 2] != 'x' || buffer[offset + 3] != 'm' || buffer[offset + 4] != 'l' || !Character.isWhitespace(buffer[offset + 5]));
        }
        return len > 2 && buffer[offset] == '<' && buffer[offset + 1] == '?' && buffer[offset + 2] != ' ' && !Character.isWhitespace(buffer[offset + 2]);
    }

    static boolean isProcessingInstructionEnd(char[] buffer, int offset, int maxi) {
        return maxi - offset > 1 && buffer[offset] == '?' && buffer[offset + 1] == '>';
    }
}

