/*
 * Decompiled with CFR 0.152.
 */
package karate.org.attoparser.select;

import java.util.Arrays;
import karate.org.attoparser.select.IMarkupSelectorItem;
import karate.org.attoparser.select.SelectorElementBuffer;

final class MarkupSelectorFilter {
    private final MarkupSelectorFilter prev;
    private MarkupSelectorFilter next;
    private final IMarkupSelectorItem markupSelectorItem;
    private static final int MATCHED_MARKUP_LEVELS_LEN = 10;
    private boolean[] matchedMarkupLevels;
    private boolean matchesThisLevel;
    private final MarkupBlockMatchingCounter markupBlockMatchingCounter = new MarkupBlockMatchingCounter();
    int markupLevelCheckerIndex;

    MarkupSelectorFilter(MarkupSelectorFilter prev, IMarkupSelectorItem markupSelectorItem) {
        this.prev = prev;
        if (this.prev != null) {
            this.prev.next = this;
        }
        this.matchedMarkupLevels = new boolean[10];
        Arrays.fill(this.matchedMarkupLevels, false);
        this.markupSelectorItem = markupSelectorItem;
    }

    boolean matchXmlDeclaration(boolean blockMatching, int markupLevel, int markupBlockIndex) {
        this.checkMarkupLevel(markupLevel);
        if (this.markupSelectorItem.anyLevel() || markupLevel == 0 || this.prev != null && this.prev.matchedMarkupLevels[markupLevel - 1]) {
            this.matchesThisLevel = this.markupSelectorItem.matchesXmlDeclaration(markupBlockIndex, this.markupBlockMatchingCounter);
            if (this.matchesPreviousOrCurrentLevel(markupLevel)) {
                if (this.next != null) {
                    return this.next.matchXmlDeclaration(blockMatching, markupLevel, markupBlockIndex);
                }
                return blockMatching ? true : this.matchesThisLevel;
            }
            if (this.matchesThisLevel) {
                return this.next == null;
            }
        } else if (this.matchesPreviousOrCurrentLevel(markupLevel)) {
            if (this.next != null) {
                return this.next.matchXmlDeclaration(blockMatching, markupLevel, markupBlockIndex);
            }
            return blockMatching;
        }
        return false;
    }

    boolean matchDocTypeClause(boolean blockMatching, int markupLevel, int markupBlockIndex) {
        this.checkMarkupLevel(markupLevel);
        if (this.markupSelectorItem.anyLevel() || markupLevel == 0 || this.prev != null && this.prev.matchedMarkupLevels[markupLevel - 1]) {
            this.matchesThisLevel = this.markupSelectorItem.matchesDocTypeClause(markupBlockIndex, this.markupBlockMatchingCounter);
            if (this.matchesPreviousOrCurrentLevel(markupLevel)) {
                if (this.next != null) {
                    return this.next.matchDocTypeClause(blockMatching, markupLevel, markupBlockIndex);
                }
                return blockMatching ? true : this.matchesThisLevel;
            }
            if (this.matchesThisLevel) {
                return this.next == null;
            }
        } else if (this.matchesPreviousOrCurrentLevel(markupLevel)) {
            if (this.next != null) {
                return this.next.matchDocTypeClause(blockMatching, markupLevel, markupBlockIndex);
            }
            return blockMatching;
        }
        return false;
    }

    boolean matchCDATASection(boolean blockMatching, int markupLevel, int markupBlockIndex) {
        this.checkMarkupLevel(markupLevel);
        if (this.markupSelectorItem.anyLevel() || markupLevel == 0 || this.prev != null && this.prev.matchedMarkupLevels[markupLevel - 1]) {
            this.matchesThisLevel = this.markupSelectorItem.matchesCDATASection(markupBlockIndex, this.markupBlockMatchingCounter);
            if (this.matchesPreviousOrCurrentLevel(markupLevel)) {
                if (this.next != null) {
                    return this.next.matchCDATASection(blockMatching, markupLevel, markupBlockIndex);
                }
                return blockMatching ? true : this.matchesThisLevel;
            }
            if (this.matchesThisLevel) {
                return this.next == null;
            }
        } else if (this.matchesPreviousOrCurrentLevel(markupLevel)) {
            if (this.next != null) {
                return this.next.matchCDATASection(blockMatching, markupLevel, markupBlockIndex);
            }
            return blockMatching;
        }
        return false;
    }

    boolean matchText(boolean blockMatching, int markupLevel, int markupBlockIndex) {
        this.checkMarkupLevel(markupLevel);
        if (this.markupSelectorItem.anyLevel() || markupLevel == 0 || this.prev != null && this.prev.matchedMarkupLevels[markupLevel - 1]) {
            this.matchesThisLevel = this.markupSelectorItem.matchesText(markupBlockIndex, this.markupBlockMatchingCounter);
            if (this.matchesPreviousOrCurrentLevel(markupLevel)) {
                if (this.next != null) {
                    return this.next.matchText(blockMatching, markupLevel, markupBlockIndex);
                }
                return blockMatching ? true : this.matchesThisLevel;
            }
            if (this.matchesThisLevel) {
                return this.next == null;
            }
        } else if (this.matchesPreviousOrCurrentLevel(markupLevel)) {
            if (this.next != null) {
                return this.next.matchText(blockMatching, markupLevel, markupBlockIndex);
            }
            return blockMatching;
        }
        return false;
    }

    boolean matchComment(boolean blockMatching, int markupLevel, int markupBlockIndex) {
        this.checkMarkupLevel(markupLevel);
        if (this.markupSelectorItem.anyLevel() || markupLevel == 0 || this.prev != null && this.prev.matchedMarkupLevels[markupLevel - 1]) {
            this.matchesThisLevel = this.markupSelectorItem.matchesComment(markupBlockIndex, this.markupBlockMatchingCounter);
            if (this.matchesPreviousOrCurrentLevel(markupLevel)) {
                if (this.next != null) {
                    return this.next.matchComment(blockMatching, markupLevel, markupBlockIndex);
                }
                return blockMatching ? true : this.matchesThisLevel;
            }
            if (this.matchesThisLevel) {
                return this.next == null;
            }
        } else if (this.matchesPreviousOrCurrentLevel(markupLevel)) {
            if (this.next != null) {
                return this.next.matchComment(blockMatching, markupLevel, markupBlockIndex);
            }
            return blockMatching;
        }
        return false;
    }

    boolean matchStandaloneElement(boolean blockMatching, int markupLevel, int markupBlockIndex, SelectorElementBuffer elementBuffer) {
        this.checkMarkupLevel(markupLevel);
        if (this.markupSelectorItem.anyLevel() || markupLevel == 0 || this.prev != null && this.prev.matchedMarkupLevels[markupLevel - 1]) {
            this.matchesThisLevel = this.markupSelectorItem.matchesElement(markupBlockIndex, elementBuffer, this.markupBlockMatchingCounter);
            if (this.matchesPreviousOrCurrentLevel(markupLevel)) {
                if (this.next != null) {
                    return this.next.matchStandaloneElement(blockMatching, markupLevel, markupBlockIndex, elementBuffer);
                }
                return blockMatching ? true : this.matchesThisLevel;
            }
            if (this.matchesThisLevel) {
                return this.next == null;
            }
        } else if (this.matchesPreviousOrCurrentLevel(markupLevel)) {
            if (this.next != null) {
                return this.next.matchStandaloneElement(blockMatching, markupLevel, markupBlockIndex, elementBuffer);
            }
            return blockMatching;
        }
        return false;
    }

    boolean matchOpenElement(boolean blockMatching, int markupLevel, int markupBlockIndex, SelectorElementBuffer elementBuffer) {
        this.checkMarkupLevel(markupLevel);
        if (this.markupSelectorItem.anyLevel() || markupLevel == 0 || this.prev != null && this.prev.matchedMarkupLevels[markupLevel - 1]) {
            this.matchesThisLevel = this.markupSelectorItem.matchesElement(markupBlockIndex, elementBuffer, this.markupBlockMatchingCounter);
            if (this.matchesPreviousOrCurrentLevel(markupLevel)) {
                this.matchedMarkupLevels[markupLevel] = this.matchesThisLevel;
                if (this.next != null) {
                    return this.next.matchOpenElement(blockMatching, markupLevel, markupBlockIndex, elementBuffer);
                }
                return blockMatching ? true : this.matchesThisLevel;
            }
            if (this.matchesThisLevel) {
                this.matchedMarkupLevels[markupLevel] = true;
                return this.next == null;
            }
        } else if (this.matchesPreviousOrCurrentLevel(markupLevel)) {
            if (this.next != null) {
                return this.next.matchOpenElement(blockMatching, markupLevel, markupBlockIndex, elementBuffer);
            }
            return blockMatching;
        }
        return false;
    }

    boolean matchProcessingInstruction(boolean blockMatching, int markupLevel, int markupBlockIndex) {
        this.checkMarkupLevel(markupLevel);
        if (this.markupSelectorItem.anyLevel() || markupLevel == 0 || this.prev != null && this.prev.matchedMarkupLevels[markupLevel - 1]) {
            this.matchesThisLevel = this.markupSelectorItem.matchesProcessingInstruction(markupBlockIndex, this.markupBlockMatchingCounter);
            if (this.matchesPreviousOrCurrentLevel(markupLevel)) {
                if (this.next != null) {
                    return this.next.matchProcessingInstruction(blockMatching, markupLevel, markupBlockIndex);
                }
                return blockMatching ? true : this.matchesThisLevel;
            }
            if (this.matchesThisLevel) {
                return this.next == null;
            }
        } else if (this.matchesPreviousOrCurrentLevel(markupLevel)) {
            if (this.next != null) {
                return this.next.matchProcessingInstruction(blockMatching, markupLevel, markupBlockIndex);
            }
            return blockMatching;
        }
        return false;
    }

    private void checkMarkupLevel(int markupLevel) {
        if (markupLevel >= this.matchedMarkupLevels.length) {
            int newLen = Math.max(markupLevel + 1, this.matchedMarkupLevels.length + 10);
            boolean[] newMatchedMarkupLevels = new boolean[newLen];
            Arrays.fill(newMatchedMarkupLevels, false);
            System.arraycopy(this.matchedMarkupLevels, 0, newMatchedMarkupLevels, 0, this.matchedMarkupLevels.length);
            this.matchedMarkupLevels = newMatchedMarkupLevels;
        }
    }

    void removeMatchesForLevel(int markupLevel) {
        if (this.matchedMarkupLevels.length > markupLevel) {
            this.matchedMarkupLevels[markupLevel] = false;
        }
        if (this.next == null) {
            return;
        }
        this.next.removeMatchesForLevel(markupLevel);
    }

    private boolean matchesPreviousOrCurrentLevel(int markupLevel) {
        this.markupLevelCheckerIndex = markupLevel;
        while (this.markupLevelCheckerIndex >= 0 && !this.matchedMarkupLevels[this.markupLevelCheckerIndex]) {
            --this.markupLevelCheckerIndex;
        }
        return this.markupLevelCheckerIndex >= 0;
    }

    static final class MarkupBlockMatchingCounter {
        static final int DEFAULT_COUNTER_SIZE = 4;
        int[] indexes = null;
        int[] counters = null;

        MarkupBlockMatchingCounter() {
        }
    }
}

