/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import karate.org.thymeleaf.DialectConfiguration;
import karate.org.thymeleaf.DialectSetConfiguration;
import karate.org.thymeleaf.IEngineConfiguration;
import karate.org.thymeleaf.cache.ICacheManager;
import karate.org.thymeleaf.context.IEngineContextFactory;
import karate.org.thymeleaf.dialect.IDialect;
import karate.org.thymeleaf.engine.AttributeDefinitions;
import karate.org.thymeleaf.engine.ElementDefinitions;
import karate.org.thymeleaf.engine.StandardModelFactory;
import karate.org.thymeleaf.engine.TemplateManager;
import karate.org.thymeleaf.expression.IExpressionObjectFactory;
import karate.org.thymeleaf.linkbuilder.ILinkBuilder;
import karate.org.thymeleaf.messageresolver.IMessageResolver;
import karate.org.thymeleaf.model.IModelFactory;
import karate.org.thymeleaf.postprocessor.IPostProcessor;
import karate.org.thymeleaf.preprocessor.IPreProcessor;
import karate.org.thymeleaf.processor.cdatasection.ICDATASectionProcessor;
import karate.org.thymeleaf.processor.comment.ICommentProcessor;
import karate.org.thymeleaf.processor.doctype.IDocTypeProcessor;
import karate.org.thymeleaf.processor.element.IElementProcessor;
import karate.org.thymeleaf.processor.processinginstruction.IProcessingInstructionProcessor;
import karate.org.thymeleaf.processor.templateboundaries.ITemplateBoundariesProcessor;
import karate.org.thymeleaf.processor.text.ITextProcessor;
import karate.org.thymeleaf.processor.xmldeclaration.IXMLDeclarationProcessor;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.templateparser.markup.decoupled.IDecoupledTemplateLogicResolver;
import karate.org.thymeleaf.templateresolver.ITemplateResolver;
import karate.org.thymeleaf.util.Validate;

public class EngineConfiguration
implements IEngineConfiguration {
    private final DialectSetConfiguration dialectSetConfiguration;
    private final Set<ITemplateResolver> templateResolvers;
    private final Set<IMessageResolver> messageResolvers;
    private final Set<ILinkBuilder> linkBuilders;
    private final ICacheManager cacheManager;
    private final IEngineContextFactory engineContextFactory;
    private final IDecoupledTemplateLogicResolver decoupledTemplateLogicResolver;
    private TemplateManager templateManager;
    private final ConcurrentHashMap<TemplateMode, IModelFactory> modelFactories;

    EngineConfiguration(Set<ITemplateResolver> templateResolvers, Set<IMessageResolver> messageResolvers, Set<ILinkBuilder> linkBuilders, Set<DialectConfiguration> dialectConfigurations, ICacheManager cacheManager, IEngineContextFactory engineContextFactory, IDecoupledTemplateLogicResolver decoupledTemplateLogicResolver) {
        Validate.notNull(templateResolvers, "Template Resolver set cannot be null");
        Validate.isTrue(templateResolvers.size() > 0, "Template Resolver set cannot be empty");
        Validate.containsNoNulls(templateResolvers, "Template Resolver set cannot contain any nulls");
        Validate.notNull(messageResolvers, "Message Resolver set cannot be null");
        Validate.notNull(dialectConfigurations, "Dialect configuration set cannot be null");
        Validate.notNull(engineContextFactory, "Engine Context Factory cannot be null");
        Validate.notNull(decoupledTemplateLogicResolver, "Decoupled Template Logic Resolver cannot be null");
        ArrayList<ITemplateResolver> templateResolversList = new ArrayList<ITemplateResolver>(templateResolvers);
        Collections.sort(templateResolversList, TemplateResolverComparator.INSTANCE);
        this.templateResolvers = Collections.unmodifiableSet(new LinkedHashSet<ITemplateResolver>(templateResolversList));
        ArrayList<IMessageResolver> messageResolversList = new ArrayList<IMessageResolver>(messageResolvers);
        Collections.sort(messageResolversList, MessageResolverComparator.INSTANCE);
        this.messageResolvers = Collections.unmodifiableSet(new LinkedHashSet<IMessageResolver>(messageResolversList));
        ArrayList<ILinkBuilder> linkBuilderList = new ArrayList<ILinkBuilder>(linkBuilders);
        Collections.sort(linkBuilderList, LinkBuilderComparator.INSTANCE);
        this.linkBuilders = Collections.unmodifiableSet(new LinkedHashSet<ILinkBuilder>(linkBuilderList));
        this.cacheManager = cacheManager;
        this.engineContextFactory = engineContextFactory;
        this.decoupledTemplateLogicResolver = decoupledTemplateLogicResolver;
        this.dialectSetConfiguration = DialectSetConfiguration.build(dialectConfigurations);
        this.modelFactories = new ConcurrentHashMap(6, 1.0f, 1);
    }

    void initialize() {
        this.templateManager = new TemplateManager(this);
    }

    @Override
    public Set<ITemplateResolver> getTemplateResolvers() {
        return this.templateResolvers;
    }

    @Override
    public Set<IMessageResolver> getMessageResolvers() {
        return this.messageResolvers;
    }

    @Override
    public Set<ILinkBuilder> getLinkBuilders() {
        return this.linkBuilders;
    }

    @Override
    public ICacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public IEngineContextFactory getEngineContextFactory() {
        return this.engineContextFactory;
    }

    @Override
    public IDecoupledTemplateLogicResolver getDecoupledTemplateLogicResolver() {
        return this.decoupledTemplateLogicResolver;
    }

    @Override
    public Set<DialectConfiguration> getDialectConfigurations() {
        return this.dialectSetConfiguration.getDialectConfigurations();
    }

    @Override
    public Set<IDialect> getDialects() {
        return this.dialectSetConfiguration.getDialects();
    }

    @Override
    public <T extends IDialect> Set<T> getDialectsOfType(Class<T> type) {
        Validate.notNull(type, "Type cannot be null");
        LinkedHashSet<IDialect> filteredDialects = new LinkedHashSet<IDialect>();
        for (IDialect dialect : this.dialectSetConfiguration.getDialects()) {
            if (!type.isInstance(dialect)) continue;
            filteredDialects.add(dialect);
        }
        return filteredDialects;
    }

    @Override
    public boolean isStandardDialectPresent() {
        return this.dialectSetConfiguration.isStandardDialectPresent();
    }

    @Override
    public String getStandardDialectPrefix() {
        return this.dialectSetConfiguration.getStandardDialectPrefix();
    }

    @Override
    public ElementDefinitions getElementDefinitions() {
        return this.dialectSetConfiguration.getElementDefinitions();
    }

    @Override
    public AttributeDefinitions getAttributeDefinitions() {
        return this.dialectSetConfiguration.getAttributeDefinitions();
    }

    @Override
    public Set<ITemplateBoundariesProcessor> getTemplateBoundariesProcessors(TemplateMode templateMode) {
        return this.dialectSetConfiguration.getTemplateBoundariesProcessors(templateMode);
    }

    @Override
    public Set<ICDATASectionProcessor> getCDATASectionProcessors(TemplateMode templateMode) {
        return this.dialectSetConfiguration.getCDATASectionProcessors(templateMode);
    }

    @Override
    public Set<ICommentProcessor> getCommentProcessors(TemplateMode templateMode) {
        return this.dialectSetConfiguration.getCommentProcessors(templateMode);
    }

    @Override
    public Set<IDocTypeProcessor> getDocTypeProcessors(TemplateMode templateMode) {
        return this.dialectSetConfiguration.getDocTypeProcessors(templateMode);
    }

    @Override
    public Set<IElementProcessor> getElementProcessors(TemplateMode templateMode) {
        return this.dialectSetConfiguration.getElementProcessors(templateMode);
    }

    @Override
    public Set<ITextProcessor> getTextProcessors(TemplateMode templateMode) {
        return this.dialectSetConfiguration.getTextProcessors(templateMode);
    }

    @Override
    public Set<IProcessingInstructionProcessor> getProcessingInstructionProcessors(TemplateMode templateMode) {
        return this.dialectSetConfiguration.getProcessingInstructionProcessors(templateMode);
    }

    @Override
    public Set<IXMLDeclarationProcessor> getXMLDeclarationProcessors(TemplateMode templateMode) {
        return this.dialectSetConfiguration.getXMLDeclarationProcessors(templateMode);
    }

    @Override
    public Set<IPreProcessor> getPreProcessors(TemplateMode templateMode) {
        return this.dialectSetConfiguration.getPreProcessors(templateMode);
    }

    @Override
    public Set<IPostProcessor> getPostProcessors(TemplateMode templateMode) {
        return this.dialectSetConfiguration.getPostProcessors(templateMode);
    }

    @Override
    public Map<String, Object> getExecutionAttributes() {
        return this.dialectSetConfiguration.getExecutionAttributes();
    }

    @Override
    public IExpressionObjectFactory getExpressionObjectFactory() {
        return this.dialectSetConfiguration.getExpressionObjectFactory();
    }

    @Override
    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    @Override
    public IModelFactory getModelFactory(TemplateMode templateMode) {
        if (this.modelFactories.containsKey((Object)templateMode)) {
            return this.modelFactories.get((Object)templateMode);
        }
        StandardModelFactory modelFactory = new StandardModelFactory(this, templateMode);
        this.modelFactories.putIfAbsent(templateMode, modelFactory);
        return this.modelFactories.get((Object)templateMode);
    }

    public boolean isModelReshapeable(TemplateMode templateMode) {
        if (!this.dialectSetConfiguration.isStandardDialectPresent()) {
            return false;
        }
        Set<ITextProcessor> textProcessors = this.dialectSetConfiguration.getTextProcessors(templateMode);
        if (textProcessors.size() > 1) {
            return false;
        }
        if (templateMode.isMarkup()) {
            Set<ICommentProcessor> commentProcessors = this.dialectSetConfiguration.getCommentProcessors(templateMode);
            if (commentProcessors.size() > (templateMode == TemplateMode.HTML ? 2 : 1)) {
                return false;
            }
            Set<ICDATASectionProcessor> cdataSectionProcessors = this.dialectSetConfiguration.getCDATASectionProcessors(templateMode);
            if (cdataSectionProcessors.size() > 1) {
                return false;
            }
        }
        if (!this.dialectSetConfiguration.getPreProcessors(templateMode).isEmpty()) {
            return false;
        }
        return this.dialectSetConfiguration.getPostProcessors(templateMode).isEmpty();
    }

    private static int nullSafeIntegerComparison(Integer o1, Integer o2) {
        return o1 != null ? (o2 != null ? o1.compareTo(o2) : -1) : (o2 != null ? 1 : 0);
    }

    private static final class TemplateResolverComparator
    implements Comparator<ITemplateResolver> {
        private static TemplateResolverComparator INSTANCE = new TemplateResolverComparator();

        TemplateResolverComparator() {
        }

        @Override
        public int compare(ITemplateResolver tr1, ITemplateResolver tr2) {
            return EngineConfiguration.nullSafeIntegerComparison(tr1.getOrder(), tr2.getOrder());
        }
    }

    private static final class MessageResolverComparator
    implements Comparator<IMessageResolver> {
        private static MessageResolverComparator INSTANCE = new MessageResolverComparator();

        MessageResolverComparator() {
        }

        @Override
        public int compare(IMessageResolver mr1, IMessageResolver mr2) {
            return EngineConfiguration.nullSafeIntegerComparison(mr1.getOrder(), mr2.getOrder());
        }
    }

    private static final class LinkBuilderComparator
    implements Comparator<ILinkBuilder> {
        private static LinkBuilderComparator INSTANCE = new LinkBuilderComparator();

        LinkBuilderComparator() {
        }

        @Override
        public int compare(ILinkBuilder mr1, ILinkBuilder mr2) {
            return EngineConfiguration.nullSafeIntegerComparison(mr1.getOrder(), mr2.getOrder());
        }
    }
}

