/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.cache;

import java.util.Collections;
import java.util.List;
import karate.org.thymeleaf.cache.ExpressionCacheKey;
import karate.org.thymeleaf.cache.ICache;
import karate.org.thymeleaf.cache.ICacheManager;
import karate.org.thymeleaf.cache.TemplateCacheKey;
import karate.org.thymeleaf.engine.TemplateModel;

public abstract class AbstractCacheManager
implements ICacheManager {
    private volatile ICache<TemplateCacheKey, TemplateModel> templateCache;
    private volatile boolean templateCacheInitialized = false;
    private volatile ICache<ExpressionCacheKey, Object> expressionCache;
    private volatile boolean expressionCacheInitialized = false;

    protected AbstractCacheManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICache<TemplateCacheKey, TemplateModel> getTemplateCache() {
        if (!this.templateCacheInitialized) {
            AbstractCacheManager abstractCacheManager = this;
            synchronized (abstractCacheManager) {
                if (!this.templateCacheInitialized) {
                    this.templateCache = this.initializeTemplateCache();
                    this.templateCacheInitialized = true;
                }
            }
        }
        return this.templateCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICache<ExpressionCacheKey, Object> getExpressionCache() {
        if (!this.expressionCacheInitialized) {
            AbstractCacheManager abstractCacheManager = this;
            synchronized (abstractCacheManager) {
                if (!this.expressionCacheInitialized) {
                    this.expressionCache = this.initializeExpressionCache();
                    this.expressionCacheInitialized = true;
                }
            }
        }
        return this.expressionCache;
    }

    @Override
    public <K, V> ICache<K, V> getSpecificCache(String name) {
        return null;
    }

    @Override
    public List<String> getAllSpecificCacheNames() {
        return Collections.emptyList();
    }

    @Override
    public void clearAllCaches() {
        List<String> allSpecificCacheNamesObj;
        ICache<ExpressionCacheKey, Object> expressionCacheObj;
        ICache<TemplateCacheKey, TemplateModel> templateCacheObj = this.getTemplateCache();
        if (templateCacheObj != null) {
            templateCacheObj.clear();
        }
        if ((expressionCacheObj = this.getExpressionCache()) != null) {
            expressionCacheObj.clear();
        }
        if ((allSpecificCacheNamesObj = this.getAllSpecificCacheNames()) != null) {
            for (String specificCacheName : allSpecificCacheNamesObj) {
                ICache specificCache = this.getSpecificCache(specificCacheName);
                if (specificCache == null) continue;
                specificCache.clear();
            }
        }
    }

    protected abstract ICache<TemplateCacheKey, TemplateModel> initializeTemplateCache();

    protected abstract ICache<ExpressionCacheKey, Object> initializeExpressionCache();
}

