/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.cache;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.util.LoggingUtils;
import karate.org.thymeleaf.util.Validate;

public final class TemplateCacheKey
implements Serializable {
    private static final long serialVersionUID = 45842555123291L;
    private final String ownerTemplate;
    private final String template;
    private final Set<String> templateSelectors;
    private final int lineOffset;
    private final int colOffset;
    private final TemplateMode templateMode;
    private final Map<String, Object> templateResolutionAttributes;
    private final int h;

    public TemplateCacheKey(String ownerTemplate, String template, Set<String> templateSelectors, int lineOffset, int colOffset, TemplateMode templateMode, Map<String, Object> templateResolutionAttributes) {
        Validate.notNull(template, "Template cannot be null");
        this.ownerTemplate = ownerTemplate;
        this.template = template;
        this.templateSelectors = templateSelectors;
        this.lineOffset = lineOffset;
        this.colOffset = colOffset;
        this.templateMode = templateMode;
        this.templateResolutionAttributes = templateResolutionAttributes;
        this.h = this.computeHashCode();
    }

    public String getOwnerTemplate() {
        return this.ownerTemplate;
    }

    public String getTemplate() {
        return this.template;
    }

    public Set<String> getTemplateSelectors() {
        return this.templateSelectors;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    public int getColOffset() {
        return this.colOffset;
    }

    public TemplateMode getTemplateMode() {
        return this.templateMode;
    }

    public Map<String, Object> getTemplateResolutionAttributes() {
        return this.templateResolutionAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TemplateCacheKey)) {
            return false;
        }
        TemplateCacheKey that = (TemplateCacheKey)o;
        if (this.h != that.h) {
            return false;
        }
        if (this.lineOffset != that.lineOffset) {
            return false;
        }
        if (this.colOffset != that.colOffset) {
            return false;
        }
        if (this.ownerTemplate != null ? !this.ownerTemplate.equals(that.ownerTemplate) : that.ownerTemplate != null) {
            return false;
        }
        if (!this.template.equals(that.template)) {
            return false;
        }
        if (this.templateSelectors != null ? !this.templateSelectors.equals(that.templateSelectors) : that.templateSelectors != null) {
            return false;
        }
        if (this.templateMode != that.templateMode) {
            return false;
        }
        return !(this.templateResolutionAttributes == null ? that.templateResolutionAttributes != null : !this.templateResolutionAttributes.equals(that.templateResolutionAttributes));
    }

    public int hashCode() {
        return this.h;
    }

    private int computeHashCode() {
        int result = this.ownerTemplate != null ? this.ownerTemplate.hashCode() : 0;
        result = 31 * result + this.template.hashCode();
        result = 31 * result + (this.templateSelectors != null ? this.templateSelectors.hashCode() : 0);
        result = 31 * result + this.lineOffset;
        result = 31 * result + this.colOffset;
        result = 31 * result + (this.templateMode != null ? this.templateMode.hashCode() : 0);
        result = 31 * result + (this.templateResolutionAttributes != null ? this.templateResolutionAttributes.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(LoggingUtils.loggifyTemplateName(this.template));
        if (this.ownerTemplate != null) {
            strBuilder.append('@');
            strBuilder.append('(');
            strBuilder.append(LoggingUtils.loggifyTemplateName(this.ownerTemplate));
            strBuilder.append(';');
            strBuilder.append(this.lineOffset);
            strBuilder.append(',');
            strBuilder.append(this.colOffset);
            strBuilder.append(')');
        }
        if (this.templateSelectors != null) {
            strBuilder.append("::");
            strBuilder.append(this.templateSelectors);
        }
        if (this.templateMode != null) {
            strBuilder.append(" @");
            strBuilder.append((Object)this.templateMode);
        }
        if (this.templateResolutionAttributes != null) {
            strBuilder.append(" (");
            strBuilder.append(this.templateResolutionAttributes);
            strBuilder.append(")");
        }
        return strBuilder.toString();
    }
}

