/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.context;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import karate.org.thymeleaf.IEngineConfiguration;
import karate.org.thymeleaf.context.Contexts;
import karate.org.thymeleaf.context.EngineContext;
import karate.org.thymeleaf.context.IContext;
import karate.org.thymeleaf.context.IEngineContext;
import karate.org.thymeleaf.context.IEngineContextFactory;
import karate.org.thymeleaf.context.IWebContext;
import karate.org.thymeleaf.context.WebEngineContext;
import karate.org.thymeleaf.engine.TemplateData;
import karate.org.thymeleaf.util.Validate;

public final class StandardEngineContextFactory
implements IEngineContextFactory {
    @Override
    public IEngineContext createEngineContext(IEngineConfiguration configuration, TemplateData templateData, Map<String, Object> templateResolutionAttributes, IContext context) {
        Validate.notNull(context, "Context object cannot be null");
        Set<String> variableNames = context.getVariableNames();
        if (variableNames == null || variableNames.isEmpty()) {
            if (Contexts.isWebContext(context)) {
                IWebContext webContext = Contexts.asWebContext(context);
                return new WebEngineContext(configuration, templateData, templateResolutionAttributes, webContext.getExchange(), webContext.getLocale(), Collections.EMPTY_MAP);
            }
            return new EngineContext(configuration, templateData, templateResolutionAttributes, context.getLocale(), Collections.EMPTY_MAP);
        }
        LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>(variableNames.size() + 1, 1.0f);
        for (String variableName : variableNames) {
            variables.put(variableName, context.getVariable(variableName));
        }
        if (Contexts.isWebContext(context)) {
            IWebContext webContext = Contexts.asWebContext(context);
            return new WebEngineContext(configuration, templateData, templateResolutionAttributes, webContext.getExchange(), webContext.getLocale(), variables);
        }
        return new EngineContext(configuration, templateData, templateResolutionAttributes, context.getLocale(), variables);
    }
}

