/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.engine;

import karate.org.thymeleaf.IEngineConfiguration;
import karate.org.thymeleaf.context.IEngineContext;
import karate.org.thymeleaf.context.ITemplateContext;
import karate.org.thymeleaf.engine.IGatheringModelProcessable;
import karate.org.thymeleaf.engine.Model;
import karate.org.thymeleaf.engine.ProcessorExecutionVars;
import karate.org.thymeleaf.engine.ProcessorTemplateHandler;
import karate.org.thymeleaf.engine.TemplateFlowController;
import karate.org.thymeleaf.engine.TemplateModelController;
import karate.org.thymeleaf.exceptions.TemplateProcessingException;
import karate.org.thymeleaf.model.ICDATASection;
import karate.org.thymeleaf.model.ICloseElementTag;
import karate.org.thymeleaf.model.IComment;
import karate.org.thymeleaf.model.IDocType;
import karate.org.thymeleaf.model.IOpenElementTag;
import karate.org.thymeleaf.model.IProcessingInstruction;
import karate.org.thymeleaf.model.IStandaloneElementTag;
import karate.org.thymeleaf.model.IText;
import karate.org.thymeleaf.model.IXMLDeclaration;

abstract class AbstractGatheringModelProcessable
implements IGatheringModelProcessable {
    private final ProcessorTemplateHandler processorTemplateHandler;
    private final IEngineContext context;
    private final Model syntheticModel;
    private final TemplateModelController modelController;
    private final TemplateFlowController flowController;
    private final TemplateModelController.SkipBody buildTimeSkipBody;
    private final boolean buildTimeSkipCloseTag;
    private final ProcessorExecutionVars processorExecutionVars;
    private boolean gatheringFinished = false;
    private int modelLevel;

    AbstractGatheringModelProcessable(IEngineConfiguration configuration, ProcessorTemplateHandler processorTemplateHandler, IEngineContext context, TemplateModelController modelController, TemplateFlowController flowController, TemplateModelController.SkipBody buildTimeSkipBody, boolean buildTimeSkipCloseTag, ProcessorExecutionVars processorExecutionVars) {
        this.processorTemplateHandler = processorTemplateHandler;
        this.context = context;
        this.modelController = modelController;
        this.flowController = flowController;
        this.buildTimeSkipBody = buildTimeSkipBody;
        this.buildTimeSkipCloseTag = buildTimeSkipCloseTag;
        if (this.context == null) {
            throw new TemplateProcessingException("Neither iteration nor model gathering are supported because local variable support is DISABLED. This is due to the use of an implementation of the " + ITemplateContext.class.getName() + " interface that does not provide local-variable support. In order to have local-variable support, the context implementation should also implement the " + IEngineContext.class.getName() + " interface");
        }
        this.syntheticModel = new Model(configuration, context.getTemplateMode());
        this.processorExecutionVars = processorExecutionVars.cloneVars();
        this.gatheringFinished = false;
        this.modelLevel = 0;
    }

    public final void resetGatheredSkipFlagsAfterNoIterations() {
        if (this.buildTimeSkipBody == TemplateModelController.SkipBody.PROCESS_ONE_ELEMENT) {
            this.modelController.skip(TemplateModelController.SkipBody.SKIP_ELEMENTS, this.buildTimeSkipCloseTag);
        } else {
            this.modelController.skip(this.buildTimeSkipBody, this.buildTimeSkipCloseTag);
        }
    }

    @Override
    public final void resetGatheredSkipFlags() {
        this.modelController.skip(this.buildTimeSkipBody, this.buildTimeSkipCloseTag);
    }

    protected final void prepareProcessing() {
        this.processorTemplateHandler.setCurrentGatheringModel(this);
        this.resetGatheredSkipFlags();
    }

    protected final ProcessorTemplateHandler getProcessorTemplateHandler() {
        return this.processorTemplateHandler;
    }

    protected final TemplateFlowController getFlowController() {
        return this.flowController;
    }

    @Override
    public final boolean isGatheringFinished() {
        return this.gatheringFinished;
    }

    protected final IEngineContext getContext() {
        return this.context;
    }

    @Override
    public ProcessorExecutionVars initializeProcessorExecutionVars() {
        return this.processorExecutionVars;
    }

    @Override
    public final Model getInnerModel() {
        return this.syntheticModel;
    }

    @Override
    public final void gatherText(IText text) {
        if (this.gatheringFinished) {
            throw new TemplateProcessingException("Gathering is finished already! We cannot gather more events");
        }
        this.syntheticModel.add(text);
    }

    @Override
    public final void gatherComment(IComment comment) {
        if (this.gatheringFinished) {
            throw new TemplateProcessingException("Gathering is finished already! We cannot gather more events");
        }
        this.syntheticModel.add(comment);
    }

    @Override
    public final void gatherCDATASection(ICDATASection cdataSection) {
        if (this.gatheringFinished) {
            throw new TemplateProcessingException("Gathering is finished already! We cannot gather more events");
        }
        this.syntheticModel.add(cdataSection);
    }

    @Override
    public final void gatherStandaloneElement(IStandaloneElementTag standaloneElementTag) {
        if (this.gatheringFinished) {
            throw new TemplateProcessingException("Gathering is finished already! We cannot gather more events");
        }
        this.syntheticModel.add(standaloneElementTag);
        if (this.modelLevel == 0) {
            this.gatheringFinished = true;
        }
    }

    @Override
    public final void gatherOpenElement(IOpenElementTag openElementTag) {
        if (this.gatheringFinished) {
            throw new TemplateProcessingException("Gathering is finished already! We cannot gather more events");
        }
        this.syntheticModel.add(openElementTag);
        ++this.modelLevel;
    }

    @Override
    public final void gatherCloseElement(ICloseElementTag closeElementTag) {
        if (closeElementTag.isUnmatched()) {
            this.gatherUnmatchedCloseElement(closeElementTag);
            return;
        }
        if (this.gatheringFinished) {
            throw new TemplateProcessingException("Gathering is finished already! We cannot gather more events");
        }
        --this.modelLevel;
        this.syntheticModel.add(closeElementTag);
        if (this.modelLevel == 0) {
            this.gatheringFinished = true;
        }
    }

    @Override
    public final void gatherUnmatchedCloseElement(ICloseElementTag closeElementTag) {
        if (this.gatheringFinished) {
            throw new TemplateProcessingException("Gathering is finished already! We cannot gather more events");
        }
        this.syntheticModel.add(closeElementTag);
    }

    @Override
    public final void gatherDocType(IDocType docType) {
        if (this.gatheringFinished) {
            throw new TemplateProcessingException("Gathering is finished already! We cannot gather more events");
        }
        this.syntheticModel.add(docType);
    }

    @Override
    public final void gatherXMLDeclaration(IXMLDeclaration xmlDeclaration) {
        if (this.gatheringFinished) {
            throw new TemplateProcessingException("Gathering is finished already! We cannot gather more events");
        }
        this.syntheticModel.add(xmlDeclaration);
    }

    @Override
    public final void gatherProcessingInstruction(IProcessingInstruction processingInstruction) {
        if (this.gatheringFinished) {
            throw new TemplateProcessingException("Gathering is finished already! We cannot gather more events");
        }
        this.syntheticModel.add(processingInstruction);
    }
}

