/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.engine;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import karate.org.thymeleaf.engine.Attribute;
import karate.org.thymeleaf.engine.AttributeDefinition;
import karate.org.thymeleaf.engine.AttributeDefinitions;
import karate.org.thymeleaf.engine.AttributeName;
import karate.org.thymeleaf.engine.AttributeNames;
import karate.org.thymeleaf.exceptions.TemplateProcessingException;
import karate.org.thymeleaf.model.AttributeValueQuotes;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.util.FastStringWriter;
import karate.org.thymeleaf.util.Validate;

final class Attributes {
    static final String DEFAULT_WHITE_SPACE = " ";
    static final String[] DEFAULT_WHITE_SPACE_ARRAY = new String[]{" "};
    static final Attributes EMPTY_ATTRIBUTES = new Attributes(null, null);
    static final Attribute[] EMPTY_ATTRIBUTE_ARRAY = new Attribute[0];
    final Attribute[] attributes;
    final String[] innerWhiteSpaces;
    private volatile int associatedProcessorCount = -1;

    Attributes(Attribute[] attributes, String[] innerWhiteSpaces) {
        this.attributes = attributes;
        this.innerWhiteSpaces = innerWhiteSpaces;
    }

    int getAssociatedProcessorCount() {
        int c = this.associatedProcessorCount;
        if (c < 0) {
            this.associatedProcessorCount = c = this.computeAssociatedProcessorCount();
        }
        return c;
    }

    private int computeAssociatedProcessorCount() {
        if (this.attributes == null || this.attributes.length == 0) {
            return 0;
        }
        int count = 0;
        int n = this.attributes.length;
        while (n-- != 0) {
            if (!this.attributes[n].definition.hasAssociatedProcessors) continue;
            count += this.attributes[n].definition.associatedProcessors.length;
        }
        return count;
    }

    private int searchAttribute(TemplateMode templateMode, String completeName) {
        if (this.attributes == null || this.attributes.length == 0) {
            return -1;
        }
        int n = this.attributes.length;
        while (n-- != 0) {
            if (!this.attributes[n].completeName.equals(completeName)) continue;
            return n;
        }
        return this.searchAttribute(AttributeNames.forName(templateMode, completeName));
    }

    private int searchAttribute(TemplateMode templateMode, String prefix, String name) {
        if (this.attributes == null || this.attributes.length == 0) {
            return -1;
        }
        if (prefix == null || prefix.length() == 0) {
            return this.searchAttribute(templateMode, name);
        }
        return this.searchAttribute(AttributeNames.forName(templateMode, prefix, name));
    }

    private int searchAttribute(AttributeName attributeName) {
        if (this.attributes == null || this.attributes.length == 0) {
            return -1;
        }
        int n = this.attributes.length;
        while (n-- != 0) {
            if (this.attributes[n].definition.attributeName != attributeName) continue;
            return n;
        }
        return -1;
    }

    boolean hasAttribute(TemplateMode templateMode, String completeName) {
        return this.searchAttribute(templateMode, completeName) >= 0;
    }

    boolean hasAttribute(TemplateMode templateMode, String prefix, String name) {
        return this.searchAttribute(templateMode, prefix, name) >= 0;
    }

    boolean hasAttribute(AttributeName attributeName) {
        return this.searchAttribute(attributeName) >= 0;
    }

    Attribute getAttribute(TemplateMode templateMode, String completeName) {
        int pos = this.searchAttribute(templateMode, completeName);
        if (pos < 0) {
            return null;
        }
        return this.attributes[pos];
    }

    Attribute getAttribute(TemplateMode templateMode, String prefix, String name) {
        int pos = this.searchAttribute(templateMode, prefix, name);
        if (pos < 0) {
            return null;
        }
        return this.attributes[pos];
    }

    Attribute getAttribute(AttributeName attributeName) {
        int pos = this.searchAttribute(attributeName);
        if (pos < 0) {
            return null;
        }
        return this.attributes[pos];
    }

    Attribute[] getAllAttributes() {
        if (this.attributes == null || this.attributes.length == 0) {
            return EMPTY_ATTRIBUTE_ARRAY;
        }
        return (Attribute[])this.attributes.clone();
    }

    Map<String, String> getAttributeMap() {
        if (this.attributes == null || this.attributes.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> attributeMap = new LinkedHashMap<String, String>(this.attributes.length + 5);
        for (int i = 0; i < this.attributes.length; ++i) {
            attributeMap.put(this.attributes[i].completeName, this.attributes[i].value);
        }
        return attributeMap;
    }

    Attributes setAttribute(AttributeDefinitions attributeDefinitions, TemplateMode templateMode, AttributeDefinition attributeDefinition, String completeName, String value, AttributeValueQuotes valueQuotes) {
        String[] newInnerWhiteSpaces;
        Attribute[] newAttributes;
        int existingIdx;
        Validate.isTrue(value != null || templateMode != TemplateMode.XML, "Cannot set null-value attributes in XML template mode");
        Validate.isTrue(valueQuotes != AttributeValueQuotes.NONE || templateMode != TemplateMode.XML, "Cannot set unquoted attributes in XML template mode");
        int n = existingIdx = attributeDefinition != null ? this.searchAttribute(attributeDefinition.attributeName) : this.searchAttribute(templateMode, completeName);
        if (existingIdx >= 0) {
            Attribute[] newAttributes2 = (Attribute[])this.attributes.clone();
            newAttributes2[existingIdx] = newAttributes2[existingIdx].modify(null, completeName, value, valueQuotes);
            return new Attributes(newAttributes2, this.innerWhiteSpaces);
        }
        AttributeDefinition newAttributeDefinition = attributeDefinition != null ? attributeDefinition : attributeDefinitions.forName(templateMode, completeName);
        Attribute newAttribute = new Attribute(newAttributeDefinition, completeName, null, value, valueQuotes, null, -1, -1);
        if (this.attributes != null) {
            newAttributes = new Attribute[this.attributes.length + 1];
            System.arraycopy(this.attributes, 0, newAttributes, 0, this.attributes.length);
            newAttributes[this.attributes.length] = newAttribute;
        } else {
            newAttributes = new Attribute[]{newAttribute};
        }
        if (this.innerWhiteSpaces != null) {
            newInnerWhiteSpaces = new String[this.innerWhiteSpaces.length + 1];
            System.arraycopy(this.innerWhiteSpaces, 0, newInnerWhiteSpaces, 0, this.innerWhiteSpaces.length);
            if (this.innerWhiteSpaces.length == (this.attributes != null ? this.attributes.length : 0)) {
                newInnerWhiteSpaces[this.innerWhiteSpaces.length] = DEFAULT_WHITE_SPACE;
            } else {
                newInnerWhiteSpaces[this.innerWhiteSpaces.length] = newInnerWhiteSpaces[this.innerWhiteSpaces.length - 1];
                newInnerWhiteSpaces[this.innerWhiteSpaces.length - 1] = DEFAULT_WHITE_SPACE;
            }
        } else {
            newInnerWhiteSpaces = DEFAULT_WHITE_SPACE_ARRAY;
        }
        return new Attributes(newAttributes, newInnerWhiteSpaces);
    }

    Attributes replaceAttribute(AttributeDefinitions attributeDefinitions, TemplateMode templateMode, AttributeName oldName, AttributeDefinition newAttributeDefinition, String newCompleteName, String value, AttributeValueQuotes valueQuotes) {
        int existingIdx;
        Validate.isTrue(value != null || templateMode != TemplateMode.XML, "Cannot set null-value attributes in XML template mode");
        Validate.isTrue(valueQuotes != AttributeValueQuotes.NONE || templateMode != TemplateMode.XML, "Cannot set unquoted attributes in XML template mode");
        if (this.attributes == null) {
            return this.setAttribute(attributeDefinitions, templateMode, newAttributeDefinition, newCompleteName, value, valueQuotes);
        }
        int oldIdx = this.searchAttribute(oldName);
        if (oldIdx < 0) {
            return this.setAttribute(attributeDefinitions, templateMode, newAttributeDefinition, newCompleteName, value, valueQuotes);
        }
        int n = existingIdx = newAttributeDefinition != null ? this.searchAttribute(newAttributeDefinition.attributeName) : this.searchAttribute(templateMode, newCompleteName);
        if (existingIdx >= 0) {
            if (oldIdx == existingIdx) {
                return this.setAttribute(attributeDefinitions, templateMode, newAttributeDefinition, newCompleteName, value, valueQuotes);
            }
            Attribute[] newAttributes = new Attribute[this.attributes.length - 1];
            System.arraycopy(this.attributes, 0, newAttributes, 0, oldIdx);
            System.arraycopy(this.attributes, oldIdx + 1, newAttributes, oldIdx, newAttributes.length - oldIdx);
            int iwIdx = oldIdx + 1;
            if (oldIdx + 1 == this.attributes.length) {
                iwIdx = oldIdx;
            }
            String[] newInnerWhiteSpaces = new String[this.innerWhiteSpaces.length - 1];
            System.arraycopy(this.innerWhiteSpaces, 0, newInnerWhiteSpaces, 0, iwIdx);
            System.arraycopy(this.innerWhiteSpaces, iwIdx + 1, newInnerWhiteSpaces, iwIdx, newInnerWhiteSpaces.length - iwIdx);
            if (existingIdx > oldIdx) {
                --existingIdx;
            }
            newAttributes[existingIdx] = newAttributes[existingIdx].modify(null, newCompleteName, value, valueQuotes);
            return new Attributes(newAttributes, newInnerWhiteSpaces);
        }
        AttributeDefinition computedNewAttributeDefinition = newAttributeDefinition != null ? newAttributeDefinition : attributeDefinitions.forName(templateMode, newCompleteName);
        Attribute[] newAttributes = (Attribute[])this.attributes.clone();
        newAttributes[oldIdx] = newAttributes[oldIdx].modify(computedNewAttributeDefinition, newCompleteName, value, valueQuotes);
        return new Attributes(newAttributes, this.innerWhiteSpaces);
    }

    Attributes removeAttribute(TemplateMode templateMode, String prefix, String name) {
        if (this.attributes == null) {
            return this;
        }
        int attrIdx = this.searchAttribute(templateMode, prefix, name);
        if (attrIdx < 0) {
            return this;
        }
        return this.removeAttribute(attrIdx);
    }

    Attributes removeAttribute(TemplateMode templateMode, String completeName) {
        if (this.attributes == null) {
            return this;
        }
        int attrIdx = this.searchAttribute(templateMode, completeName);
        if (attrIdx < 0) {
            return this;
        }
        return this.removeAttribute(attrIdx);
    }

    Attributes removeAttribute(AttributeName attributeName) {
        if (this.attributes == null) {
            return this;
        }
        int attrIdx = this.searchAttribute(attributeName);
        if (attrIdx < 0) {
            return this;
        }
        return this.removeAttribute(attrIdx);
    }

    private Attributes removeAttribute(int attrIdx) {
        Attribute[] newAttributes;
        if (this.attributes.length == 1 && this.innerWhiteSpaces.length == 1) {
            return EMPTY_ATTRIBUTES;
        }
        if (this.attributes.length == 1) {
            newAttributes = null;
        } else {
            newAttributes = new Attribute[this.attributes.length - 1];
            System.arraycopy(this.attributes, 0, newAttributes, 0, attrIdx);
            System.arraycopy(this.attributes, attrIdx + 1, newAttributes, attrIdx, newAttributes.length - attrIdx);
        }
        int iwIdx = attrIdx + 1;
        if (attrIdx + 1 == this.attributes.length) {
            iwIdx = attrIdx;
        }
        String[] newInnerWhiteSpaces = new String[this.innerWhiteSpaces.length - 1];
        System.arraycopy(this.innerWhiteSpaces, 0, newInnerWhiteSpaces, 0, iwIdx);
        System.arraycopy(this.innerWhiteSpaces, iwIdx + 1, newInnerWhiteSpaces, iwIdx, newInnerWhiteSpaces.length - iwIdx);
        return new Attributes(newAttributes, newInnerWhiteSpaces);
    }

    void write(Writer writer) throws IOException {
        int i;
        if (this.attributes == null) {
            if (this.innerWhiteSpaces != null) {
                writer.write(this.innerWhiteSpaces[0]);
            }
            return;
        }
        for (i = 0; i < this.attributes.length; ++i) {
            writer.write(this.innerWhiteSpaces[i]);
            this.attributes[i].write(writer);
        }
        if (i < this.innerWhiteSpaces.length) {
            writer.write(this.innerWhiteSpaces[i]);
        }
    }

    public String toString() {
        FastStringWriter stringWriter = new FastStringWriter();
        try {
            this.write(stringWriter);
        }
        catch (IOException e) {
            throw new TemplateProcessingException("Exception processing String form of ElementAttributes", e);
        }
        return ((Object)stringWriter).toString();
    }
}

