/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.engine;

import java.io.IOException;
import java.io.Writer;
import karate.org.thymeleaf.engine.AbstractElementTag;
import karate.org.thymeleaf.engine.ElementDefinition;
import karate.org.thymeleaf.engine.IEngineTemplateEvent;
import karate.org.thymeleaf.engine.ITemplateHandler;
import karate.org.thymeleaf.model.ICloseElementTag;
import karate.org.thymeleaf.model.IModelVisitor;
import karate.org.thymeleaf.templatemode.TemplateMode;

final class CloseElementTag
extends AbstractElementTag
implements ICloseElementTag,
IEngineTemplateEvent {
    final String trailingWhiteSpace;
    final boolean unmatched;

    CloseElementTag(TemplateMode templateMode, ElementDefinition elementDefinition, String elementCompleteName, String trailingWhiteSpace, boolean synthetic, boolean unmatched) {
        super(templateMode, elementDefinition, elementCompleteName, synthetic);
        this.trailingWhiteSpace = trailingWhiteSpace;
        this.unmatched = unmatched;
    }

    CloseElementTag(TemplateMode templateMode, ElementDefinition elementDefinition, String elementCompleteName, String trailingWhiteSpace, boolean synthetic, boolean unmatched, String templateName, int line, int col) {
        super(templateMode, elementDefinition, elementCompleteName, synthetic, templateName, line, col);
        this.trailingWhiteSpace = trailingWhiteSpace;
        this.unmatched = unmatched;
    }

    @Override
    public boolean isUnmatched() {
        return this.unmatched;
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void write(Writer writer) throws IOException {
        if (this.synthetic) {
            return;
        }
        if (this.templateMode.isText()) {
            writer.write("[/");
            writer.write(this.elementCompleteName);
            if (this.trailingWhiteSpace != null) {
                writer.write(this.trailingWhiteSpace);
            }
            writer.write("]");
            return;
        }
        writer.write("</");
        writer.write(this.elementCompleteName);
        if (this.trailingWhiteSpace != null) {
            writer.write(this.trailingWhiteSpace);
        }
        writer.write(62);
    }

    static CloseElementTag asEngineCloseElementTag(ICloseElementTag closeElementTag) {
        if (closeElementTag instanceof CloseElementTag) {
            return (CloseElementTag)closeElementTag;
        }
        return new CloseElementTag(closeElementTag.getTemplateMode(), closeElementTag.getElementDefinition(), closeElementTag.getElementCompleteName(), null, closeElementTag.isSynthetic(), closeElementTag.isUnmatched(), closeElementTag.getTemplateName(), closeElementTag.getLine(), closeElementTag.getCol());
    }

    @Override
    public void beHandled(ITemplateHandler handler) {
        handler.handleCloseElement(this);
    }
}

