/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.engine;

import java.io.IOException;
import java.io.Writer;
import karate.org.thymeleaf.engine.AbstractTextualTemplateEvent;
import karate.org.thymeleaf.engine.ITemplateHandler;
import karate.org.thymeleaf.model.IComment;
import karate.org.thymeleaf.model.IModelVisitor;

final class Comment
extends AbstractTextualTemplateEvent
implements IComment {
    private static final String COMMENT_PREFIX = "<!--";
    private static final String COMMENT_SUFFIX = "-->";
    final String prefix;
    final String suffix;
    private volatile String computedCommentStr = null;

    Comment(CharSequence content) {
        this(COMMENT_PREFIX, content, COMMENT_SUFFIX);
    }

    Comment(String prefix, CharSequence content, String suffix) {
        super(content);
        this.prefix = prefix;
        this.suffix = suffix;
    }

    Comment(CharSequence content, String templateName, int line, int col) {
        this(COMMENT_PREFIX, content, COMMENT_SUFFIX, templateName, line, col);
    }

    Comment(String prefix, CharSequence content, String suffix, String templateName, int line, int col) {
        super(content, templateName, line, col);
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    public String getComment() {
        String c = this.computedCommentStr;
        if (c == null) {
            this.computedCommentStr = c = this.prefix + this.getContentText() + this.suffix;
        }
        return c;
    }

    @Override
    public String getContent() {
        return this.getContentText();
    }

    @Override
    public int length() {
        return this.prefix.length() + this.getContentLength() + this.suffix.length();
    }

    @Override
    public char charAt(int index) {
        if (index < this.prefix.length()) {
            return this.prefix.charAt(index);
        }
        int prefixedContentLen = this.prefix.length() + this.getContentLength();
        if (index >= prefixedContentLen) {
            return this.suffix.charAt(index - prefixedContentLen);
        }
        return this.charAtContent(index - this.prefix.length());
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start >= this.prefix.length() && end < this.prefix.length() + this.getContentLength()) {
            return this.contentSubSequence(start - this.prefix.length(), end - this.prefix.length());
        }
        return this.getComment().subSequence(start, end);
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.prefix);
        this.writeContent(writer);
        writer.write(this.suffix);
    }

    static Comment asEngineComment(IComment comment) {
        if (comment instanceof Comment) {
            return (Comment)comment;
        }
        return new Comment(comment.getContent(), comment.getTemplateName(), comment.getLine(), comment.getCol());
    }

    @Override
    public void beHandled(ITemplateHandler handler) {
        handler.handleComment(this);
    }

    @Override
    public String toString() {
        return this.getComment();
    }
}

