/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.engine;

import java.util.Map;
import karate.org.thymeleaf.IEngineConfiguration;
import karate.org.thymeleaf.context.IContext;
import karate.org.thymeleaf.context.IEngineContext;
import karate.org.thymeleaf.context.IEngineContextFactory;
import karate.org.thymeleaf.engine.TemplateData;

final class EngineContextManager {
    static IEngineContext prepareEngineContext(IEngineConfiguration configuration, TemplateData templateData, Map<String, Object> templateResolutionAttributes, IContext context) {
        IEngineContext engineContext = EngineContextManager.createEngineContextIfNeeded(configuration, templateData, templateResolutionAttributes, context);
        engineContext.increaseLevel();
        if (context instanceof IEngineContext) {
            engineContext.setTemplateData(templateData);
        }
        return engineContext;
    }

    static void disposeEngineContext(IEngineContext engineContext) {
        engineContext.decreaseLevel();
    }

    private static IEngineContext createEngineContextIfNeeded(IEngineConfiguration configuration, TemplateData templateData, Map<String, Object> templateResolutionAttributes, IContext context) {
        if (context instanceof IEngineContext) {
            return (IEngineContext)context;
        }
        IEngineContextFactory engineContextFactory = configuration.getEngineContextFactory();
        return engineContextFactory.createEngineContext(configuration, templateData, templateResolutionAttributes, context);
    }

    private EngineContextManager() {
    }
}

