/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.engine;

import java.io.Writer;
import karate.org.thymeleaf.engine.AbstractTemplateHandler;
import karate.org.thymeleaf.exceptions.TemplateOutputException;
import karate.org.thymeleaf.model.ICDATASection;
import karate.org.thymeleaf.model.ICloseElementTag;
import karate.org.thymeleaf.model.IComment;
import karate.org.thymeleaf.model.IDocType;
import karate.org.thymeleaf.model.IOpenElementTag;
import karate.org.thymeleaf.model.IProcessingInstruction;
import karate.org.thymeleaf.model.IStandaloneElementTag;
import karate.org.thymeleaf.model.IText;
import karate.org.thymeleaf.model.IXMLDeclaration;

public final class OutputTemplateHandler
extends AbstractTemplateHandler {
    private final Writer writer;

    public OutputTemplateHandler(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("Writer cannot be null");
        }
        this.writer = writer;
    }

    @Override
    public void handleText(IText text) {
        try {
            text.write(this.writer);
        }
        catch (Exception e) {
            throw new TemplateOutputException("An error happened during template rendering", text.getTemplateName(), text.getLine(), text.getCol(), e);
        }
        super.handleText(text);
    }

    @Override
    public void handleComment(IComment comment) {
        try {
            comment.write(this.writer);
        }
        catch (Exception e) {
            throw new TemplateOutputException("An error happened during template rendering", comment.getTemplateName(), comment.getLine(), comment.getCol(), e);
        }
        super.handleComment(comment);
    }

    @Override
    public void handleCDATASection(ICDATASection cdataSection) {
        try {
            cdataSection.write(this.writer);
        }
        catch (Exception e) {
            throw new TemplateOutputException("An error happened during template rendering", cdataSection.getTemplateName(), cdataSection.getLine(), cdataSection.getCol(), e);
        }
        super.handleCDATASection(cdataSection);
    }

    @Override
    public void handleStandaloneElement(IStandaloneElementTag standaloneElementTag) {
        try {
            standaloneElementTag.write(this.writer);
        }
        catch (Exception e) {
            throw new TemplateOutputException("An error happened during template rendering", standaloneElementTag.getTemplateName(), standaloneElementTag.getLine(), standaloneElementTag.getCol(), e);
        }
        super.handleStandaloneElement(standaloneElementTag);
    }

    @Override
    public void handleOpenElement(IOpenElementTag openElementTag) {
        try {
            openElementTag.write(this.writer);
        }
        catch (Exception e) {
            throw new TemplateOutputException("An error happened during template rendering", openElementTag.getTemplateName(), openElementTag.getLine(), openElementTag.getCol(), e);
        }
        super.handleOpenElement(openElementTag);
    }

    @Override
    public void handleCloseElement(ICloseElementTag closeElementTag) {
        try {
            closeElementTag.write(this.writer);
        }
        catch (Exception e) {
            throw new TemplateOutputException("An error happened during template rendering", closeElementTag.getTemplateName(), closeElementTag.getLine(), closeElementTag.getCol(), e);
        }
        super.handleCloseElement(closeElementTag);
    }

    @Override
    public void handleDocType(IDocType docType) {
        try {
            docType.write(this.writer);
        }
        catch (Exception e) {
            throw new TemplateOutputException("An error happened during template rendering", docType.getTemplateName(), docType.getLine(), docType.getCol(), e);
        }
        super.handleDocType(docType);
    }

    @Override
    public void handleXMLDeclaration(IXMLDeclaration xmlDeclaration) {
        try {
            xmlDeclaration.write(this.writer);
        }
        catch (Exception e) {
            throw new TemplateOutputException("An error happened during template rendering", xmlDeclaration.getTemplateName(), xmlDeclaration.getLine(), xmlDeclaration.getCol(), e);
        }
        super.handleXMLDeclaration(xmlDeclaration);
    }

    @Override
    public void handleProcessingInstruction(IProcessingInstruction processingInstruction) {
        try {
            processingInstruction.write(this.writer);
        }
        catch (Exception e) {
            throw new TemplateOutputException("An error happened during template rendering", processingInstruction.getTemplateName(), processingInstruction.getLine(), processingInstruction.getCol(), e);
        }
        super.handleProcessingInstruction(processingInstruction);
    }
}

