/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.engine;

import karate.org.thymeleaf.context.IEngineContext;
import karate.org.thymeleaf.engine.IEngineProcessable;
import karate.org.thymeleaf.engine.ITemplateHandler;
import karate.org.thymeleaf.engine.ProcessorExecutionVars;
import karate.org.thymeleaf.engine.ProcessorTemplateHandler;
import karate.org.thymeleaf.engine.StandaloneElementTag;
import karate.org.thymeleaf.engine.TemplateFlowController;
import karate.org.thymeleaf.engine.TemplateModelController;

final class StandaloneElementTagModelProcessable
implements IEngineProcessable {
    private final StandaloneElementTag standaloneElementTag;
    private final ProcessorExecutionVars vars;
    private final IEngineContext context;
    private final TemplateFlowController flowController;
    private final TemplateModelController modelController;
    private final ProcessorTemplateHandler processorTemplateHandler;
    private final ITemplateHandler nextTemplateHandler;
    private boolean beforeProcessed;
    private boolean delegationProcessed;
    private boolean afterProcessed;
    private int offset;

    StandaloneElementTagModelProcessable(StandaloneElementTag standaloneElementTag, ProcessorExecutionVars vars, IEngineContext context, TemplateModelController modelController, TemplateFlowController flowController, ProcessorTemplateHandler processorTemplateHandler, ITemplateHandler nextTemplateHandler) {
        this.standaloneElementTag = standaloneElementTag;
        this.vars = vars;
        this.context = context;
        this.flowController = flowController;
        this.modelController = modelController;
        this.processorTemplateHandler = processorTemplateHandler;
        this.nextTemplateHandler = nextTemplateHandler;
        this.beforeProcessed = false;
        this.delegationProcessed = false;
        this.afterProcessed = false;
        this.offset = 0;
    }

    @Override
    public boolean process() {
        if (this.flowController.stopProcessing) {
            return false;
        }
        if (!this.beforeProcessed) {
            if (this.vars.modelBefore != null) {
                this.offset += this.vars.modelBefore.process(this.nextTemplateHandler, this.offset, this.flowController);
                if (this.offset < this.vars.modelBefore.queueSize || this.flowController.stopProcessing) {
                    return false;
                }
            }
            this.beforeProcessed = true;
            this.offset = 0;
        }
        if (!this.delegationProcessed) {
            if (!this.vars.discardEvent) {
                this.nextTemplateHandler.handleStandaloneElement(this.standaloneElementTag);
            }
            this.delegationProcessed = true;
            this.offset = 0;
        }
        if (this.flowController.stopProcessing) {
            return false;
        }
        if (!this.afterProcessed) {
            if (this.vars.modelAfter != null) {
                ITemplateHandler modelHandler = this.vars.modelAfterProcessable ? this.processorTemplateHandler : this.nextTemplateHandler;
                this.offset += this.vars.modelAfter.process(modelHandler, this.offset, this.flowController);
                if (this.offset < this.vars.modelAfter.queueSize || this.flowController.stopProcessing) {
                    return false;
                }
            }
            this.afterProcessed = true;
        }
        if (this.context != null) {
            this.context.decreaseLevel();
        }
        return true;
    }
}

