/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.engine;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import karate.org.thymeleaf.engine.IThrottledTemplateWriterControl;
import karate.org.thymeleaf.engine.TemplateFlowController;
import karate.org.thymeleaf.engine.ThrottledTemplateWriterOutputStreamAdapter;
import karate.org.thymeleaf.engine.ThrottledTemplateWriterWriterAdapter;
import karate.org.thymeleaf.exceptions.TemplateOutputException;

class ThrottledTemplateWriter
extends Writer
implements IThrottledTemplateWriterControl {
    private final String templateName;
    private final TemplateFlowController flowController;
    private IThrottledTemplateWriterAdapter adapter;
    private Writer writer;
    private boolean flushable;

    ThrottledTemplateWriter(String templateName, TemplateFlowController flowController) {
        this.templateName = templateName;
        this.flowController = flowController;
        this.adapter = null;
        this.writer = null;
        this.flushable = false;
    }

    void setOutput(Writer writer) {
        if (this.adapter != null && this.adapter instanceof ThrottledTemplateWriterOutputStreamAdapter) {
            throw new TemplateOutputException("The throttled processor has already been initialized to use byte-based output (OutputStream), but a Writer has been specified.", this.templateName, -1, -1, null);
        }
        if (this.adapter == null) {
            this.adapter = new ThrottledTemplateWriterWriterAdapter(this.templateName, this.flowController);
            this.writer = (ThrottledTemplateWriterWriterAdapter)this.adapter;
        }
        ((ThrottledTemplateWriterWriterAdapter)this.adapter).setWriter(writer);
    }

    void setOutput(OutputStream outputStream, Charset charset, int maxOutputInBytes) {
        if (this.adapter != null && this.adapter instanceof ThrottledTemplateWriterWriterAdapter) {
            throw new TemplateOutputException("The throttled processor has already been initialized to use char-based output (Writer), but an OutputStream has been specified.", this.templateName, -1, -1, null);
        }
        if (this.adapter == null) {
            int adapterOverflowBufferIncrementBytes = maxOutputInBytes == Integer.MAX_VALUE ? 128 : Math.min(128, Math.max(16, maxOutputInBytes / 8));
            this.adapter = new ThrottledTemplateWriterOutputStreamAdapter(this.templateName, this.flowController, adapterOverflowBufferIncrementBytes);
            CharsetEncoder charsetEncoder = charset.newEncoder();
            int channelBufferSize = maxOutputInBytes == Integer.MAX_VALUE ? 1024 : Math.min(512, Math.max(64, adapterOverflowBufferIncrementBytes * 2));
            WritableByteChannel channel = Channels.newChannel((ThrottledTemplateWriterOutputStreamAdapter)this.adapter);
            this.writer = Channels.newWriter(channel, charsetEncoder, channelBufferSize);
        }
        ((ThrottledTemplateWriterOutputStreamAdapter)this.adapter).setOutputStream(outputStream);
    }

    @Override
    public boolean isOverflown() throws IOException {
        if (this.flushable) {
            this.flush();
            this.flushable = false;
        }
        return this.adapter.isOverflown();
    }

    @Override
    public boolean isStopped() throws IOException {
        if (this.flushable) {
            this.flush();
            this.flushable = false;
        }
        return this.adapter.isStopped();
    }

    @Override
    public int getWrittenCount() {
        return this.adapter.getWrittenCount();
    }

    @Override
    public int getMaxOverflowSize() {
        return this.adapter.getMaxOverflowSize();
    }

    @Override
    public int getOverflowGrowCount() {
        return this.adapter.getOverflowGrowCount();
    }

    void allow(int limit) {
        this.adapter.allow(limit);
    }

    @Override
    public void write(int c) throws IOException {
        this.flushable = true;
        this.writer.write(c);
    }

    @Override
    public void write(String str) throws IOException {
        this.flushable = true;
        this.writer.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.flushable = true;
        this.writer.write(str, off, len);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.flushable = true;
        this.writer.write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.flushable = true;
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    static interface IThrottledTemplateWriterAdapter {
        public boolean isOverflown();

        public boolean isStopped();

        public int getWrittenCount();

        public int getMaxOverflowSize();

        public int getOverflowGrowCount();

        public void allow(int var1);
    }
}

