/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.expression;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import karate.org.thymeleaf.context.IExpressionContext;
import karate.org.thymeleaf.expression.IExpressionObjectFactory;
import karate.org.thymeleaf.expression.IExpressionObjects;
import karate.org.thymeleaf.util.Validate;

public class ExpressionObjects
implements IExpressionObjects {
    private static final int EXPRESSION_OBJECT_MAP_DEFAULT_SIZE = 3;
    private final IExpressionContext context;
    private final IExpressionObjectFactory expressionObjectFactory;
    private final Set<String> expressionObjectNames;
    private Map<String, Object> objects;

    public ExpressionObjects(IExpressionContext context, IExpressionObjectFactory expressionObjectFactory) {
        Validate.notNull(context, "Context cannot be null");
        Validate.notNull(expressionObjectFactory, "Expression Object Factory cannot be null");
        this.context = context;
        this.expressionObjectFactory = expressionObjectFactory;
        this.expressionObjectNames = this.expressionObjectFactory.getAllExpressionObjectNames();
    }

    @Override
    public int size() {
        return this.expressionObjectNames.size();
    }

    @Override
    public boolean containsObject(String name) {
        return this.expressionObjectNames.contains(name);
    }

    @Override
    public Set<String> getObjectNames() {
        return this.expressionObjectNames;
    }

    @Override
    public Object getObject(String name) {
        if (this.objects != null && this.objects.containsKey(name)) {
            return this.objects.get(name);
        }
        if (!this.expressionObjectNames.contains(name)) {
            return null;
        }
        Object object = this.expressionObjectFactory.buildObject(this.context, name);
        if (!this.expressionObjectFactory.isCacheable(name)) {
            return object;
        }
        if (this.objects == null) {
            this.objects = new HashMap<String, Object>(3);
        }
        this.objects.put(name, object);
        return object;
    }
}

