/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.processor.element;

import karate.org.thymeleaf.context.ITemplateContext;
import karate.org.thymeleaf.engine.AttributeName;
import karate.org.thymeleaf.exceptions.TemplateProcessingException;
import karate.org.thymeleaf.model.IAttribute;
import karate.org.thymeleaf.model.IModel;
import karate.org.thymeleaf.model.IModelFactory;
import karate.org.thymeleaf.model.IProcessableElementTag;
import karate.org.thymeleaf.model.ITemplateEvent;
import karate.org.thymeleaf.processor.element.AbstractElementModelProcessor;
import karate.org.thymeleaf.processor.element.IElementModelStructureHandler;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.util.EscapedAttributeUtils;

public abstract class AbstractAttributeModelProcessor
extends AbstractElementModelProcessor {
    private final boolean removeAttribute;

    protected AbstractAttributeModelProcessor(TemplateMode templateMode, String dialectPrefix, String elementName, boolean prefixElementName, String attributeName, boolean prefixAttributeName, int precedence, boolean removeAttribute) {
        super(templateMode, dialectPrefix, elementName, prefixElementName, attributeName, prefixAttributeName, precedence);
        this.removeAttribute = removeAttribute;
    }

    @Override
    protected final void doProcess(ITemplateContext context, IModel model, IElementModelStructureHandler structureHandler) {
        AttributeName attributeName = null;
        ITemplateEvent firstEvent = null;
        try {
            int firstEventLocation;
            attributeName = this.getMatchingAttributeName().getMatchingAttributeName();
            firstEvent = (IProcessableElementTag)model.get(0);
            String attributeValue = EscapedAttributeUtils.unescapeAttribute(context.getTemplateMode(), firstEvent.getAttributeValue(attributeName));
            this.doProcess(context, model, attributeName, attributeValue, structureHandler);
            if (this.removeAttribute && (firstEventLocation = AbstractAttributeModelProcessor.locateFirstEventInModel(model, firstEvent)) >= 0) {
                firstEvent = (IProcessableElementTag)model.get(firstEventLocation);
                IModelFactory modelFactory = context.getModelFactory();
                ITemplateEvent newFirstEvent = modelFactory.removeAttribute(firstEvent, attributeName);
                if (newFirstEvent != firstEvent) {
                    model.replace(firstEventLocation, newFirstEvent);
                }
            }
        }
        catch (TemplateProcessingException e) {
            if (firstEvent != null) {
                int attributeCol;
                String attributeTemplateName = firstEvent.getTemplateName();
                IAttribute attribute = firstEvent.getAttribute(attributeName);
                int attributeLine = attribute != null ? attribute.getLine() : -1;
                int n = attributeCol = attribute != null ? attribute.getCol() : -1;
                if (attributeTemplateName != null && !e.hasTemplateName()) {
                    e.setTemplateName(attributeTemplateName);
                }
                if (attributeLine != -1 && attributeCol != -1 && !e.hasLineAndCol()) {
                    e.setLineAndCol(attributeLine, attributeCol);
                }
            }
            throw e;
        }
        catch (Exception e) {
            String attributeTemplateName = null;
            int attributeLine = -1;
            int attributeCol = -1;
            if (firstEvent != null) {
                attributeTemplateName = firstEvent.getTemplateName();
                IAttribute attribute = firstEvent.getAttribute(attributeName);
                attributeLine = attribute != null ? attribute.getLine() : -1;
                attributeCol = attribute != null ? attribute.getCol() : -1;
            }
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", attributeTemplateName, attributeLine, attributeCol, e);
        }
    }

    protected abstract void doProcess(ITemplateContext var1, IModel var2, AttributeName var3, String var4, IElementModelStructureHandler var5);

    private static int locateFirstEventInModel(IModel model, ITemplateEvent firstEvent) {
        int modelSize = model.size();
        for (int i = 0; i < modelSize; ++i) {
            if (firstEvent != model.get(i)) continue;
            return i;
        }
        if (modelSize > 0 && model.get(0) instanceof IProcessableElementTag) {
            return 0;
        }
        return -1;
    }
}

