/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.processor.element;

import karate.org.thymeleaf.context.ITemplateContext;
import karate.org.thymeleaf.engine.AttributeName;
import karate.org.thymeleaf.exceptions.TemplateProcessingException;
import karate.org.thymeleaf.model.IAttribute;
import karate.org.thymeleaf.model.IProcessableElementTag;
import karate.org.thymeleaf.processor.element.AbstractElementTagProcessor;
import karate.org.thymeleaf.processor.element.IElementTagStructureHandler;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.util.EscapedAttributeUtils;
import karate.org.thymeleaf.util.Validate;

public abstract class AbstractAttributeTagProcessor
extends AbstractElementTagProcessor {
    private final boolean removeAttribute;

    protected AbstractAttributeTagProcessor(TemplateMode templateMode, String dialectPrefix, String elementName, boolean prefixElementName, String attributeName, boolean prefixAttributeName, int precedence, boolean removeAttribute) {
        super(templateMode, dialectPrefix, elementName, prefixElementName, attributeName, prefixAttributeName, precedence);
        Validate.notEmpty(attributeName, "Attribute name cannot be null or empty in Attribute Tag Processor");
        this.removeAttribute = removeAttribute;
    }

    @Override
    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, IElementTagStructureHandler structureHandler) {
        AttributeName attributeName = null;
        try {
            attributeName = this.getMatchingAttributeName().getMatchingAttributeName();
            String attributeValue = EscapedAttributeUtils.unescapeAttribute(context.getTemplateMode(), tag.getAttributeValue(attributeName));
            this.doProcess(context, tag, attributeName, attributeValue, structureHandler);
            if (this.removeAttribute) {
                structureHandler.removeAttribute(attributeName);
            }
        }
        catch (TemplateProcessingException e) {
            if (tag.hasLocation()) {
                if (!e.hasTemplateName()) {
                    e.setTemplateName(tag.getTemplateName());
                }
                if (!e.hasLineAndCol()) {
                    if (attributeName == null) {
                        e.setLineAndCol(tag.getLine(), tag.getCol());
                    } else {
                        IAttribute attribute = tag.getAttribute(attributeName);
                        if (attribute != null) {
                            e.setLineAndCol(attribute.getLine(), attribute.getCol());
                        }
                    }
                }
            }
            throw e;
        }
        catch (Exception e) {
            IAttribute attribute;
            int line = tag.getLine();
            int col = tag.getCol();
            if (attributeName != null && (attribute = tag.getAttribute(attributeName)) != null) {
                line = attribute.getLine();
                col = attribute.getCol();
            }
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", tag.getTemplateName(), line, col, e);
        }
    }

    protected abstract void doProcess(ITemplateContext var1, IProcessableElementTag var2, AttributeName var3, String var4, IElementTagStructureHandler var5);
}

