/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.processor.element;

import karate.org.thymeleaf.context.ITemplateContext;
import karate.org.thymeleaf.engine.AttributeNames;
import karate.org.thymeleaf.engine.ElementNames;
import karate.org.thymeleaf.exceptions.TemplateProcessingException;
import karate.org.thymeleaf.model.IModel;
import karate.org.thymeleaf.model.ITemplateEvent;
import karate.org.thymeleaf.processor.AbstractProcessor;
import karate.org.thymeleaf.processor.element.IElementModelProcessor;
import karate.org.thymeleaf.processor.element.IElementModelStructureHandler;
import karate.org.thymeleaf.processor.element.MatchingAttributeName;
import karate.org.thymeleaf.processor.element.MatchingElementName;
import karate.org.thymeleaf.templatemode.TemplateMode;

public abstract class AbstractElementModelProcessor
extends AbstractProcessor
implements IElementModelProcessor {
    private final String dialectPrefix;
    private final MatchingElementName matchingElementName;
    private final MatchingAttributeName matchingAttributeName;

    public AbstractElementModelProcessor(TemplateMode templateMode, String dialectPrefix, String elementName, boolean prefixElementName, String attributeName, boolean prefixAttributeName, int precedence) {
        super(templateMode, precedence);
        this.dialectPrefix = dialectPrefix;
        MatchingElementName matchingElementName = elementName == null ? null : (this.matchingElementName = MatchingElementName.forElementName(templateMode, ElementNames.forName(templateMode, prefixElementName ? this.dialectPrefix : null, elementName)));
        this.matchingAttributeName = attributeName == null ? null : MatchingAttributeName.forAttributeName(templateMode, AttributeNames.forName(templateMode, prefixAttributeName ? this.dialectPrefix : null, attributeName));
    }

    protected final String getDialectPrefix() {
        return this.dialectPrefix;
    }

    @Override
    public final MatchingElementName getMatchingElementName() {
        return this.matchingElementName;
    }

    @Override
    public final MatchingAttributeName getMatchingAttributeName() {
        return this.matchingAttributeName;
    }

    @Override
    public final void process(ITemplateContext context, IModel model, IElementModelStructureHandler structureHandler) {
        ITemplateEvent firstEvent = null;
        try {
            firstEvent = model.get(0);
            this.doProcess(context, model, structureHandler);
        }
        catch (TemplateProcessingException e) {
            if (firstEvent != null) {
                String modelTemplateName = firstEvent.getTemplateName();
                int modelLine = firstEvent.getLine();
                int modelCol = firstEvent.getCol();
                if (modelTemplateName != null && !e.hasTemplateName()) {
                    e.setTemplateName(modelTemplateName);
                }
                if (modelLine != -1 && modelCol != -1 && !e.hasLineAndCol()) {
                    e.setLineAndCol(modelLine, modelCol);
                }
            }
            throw e;
        }
        catch (Exception e) {
            String modelTemplateName = null;
            int modelLine = -1;
            int modelCol = -1;
            if (firstEvent != null) {
                modelTemplateName = firstEvent.getTemplateName();
                modelLine = firstEvent.getLine();
                modelCol = firstEvent.getCol();
            }
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", modelTemplateName, modelLine, modelCol, e);
        }
    }

    protected abstract void doProcess(ITemplateContext var1, IModel var2, IElementModelStructureHandler var3);
}

