/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.processor.element;

import karate.org.thymeleaf.context.ITemplateContext;
import karate.org.thymeleaf.engine.AttributeNames;
import karate.org.thymeleaf.engine.ElementNames;
import karate.org.thymeleaf.exceptions.TemplateProcessingException;
import karate.org.thymeleaf.model.IProcessableElementTag;
import karate.org.thymeleaf.processor.AbstractProcessor;
import karate.org.thymeleaf.processor.element.IElementTagProcessor;
import karate.org.thymeleaf.processor.element.IElementTagStructureHandler;
import karate.org.thymeleaf.processor.element.MatchingAttributeName;
import karate.org.thymeleaf.processor.element.MatchingElementName;
import karate.org.thymeleaf.templatemode.TemplateMode;

public abstract class AbstractElementTagProcessor
extends AbstractProcessor
implements IElementTagProcessor {
    private final String dialectPrefix;
    private final MatchingElementName matchingElementName;
    private final MatchingAttributeName matchingAttributeName;

    public AbstractElementTagProcessor(TemplateMode templateMode, String dialectPrefix, String elementName, boolean prefixElementName, String attributeName, boolean prefixAttributeName, int precedence) {
        super(templateMode, precedence);
        this.dialectPrefix = dialectPrefix;
        MatchingElementName matchingElementName = elementName == null ? null : (this.matchingElementName = MatchingElementName.forElementName(templateMode, ElementNames.forName(templateMode, prefixElementName ? this.dialectPrefix : null, elementName)));
        this.matchingAttributeName = attributeName == null ? null : MatchingAttributeName.forAttributeName(templateMode, AttributeNames.forName(templateMode, prefixAttributeName ? this.dialectPrefix : null, attributeName));
    }

    protected final String getDialectPrefix() {
        return this.dialectPrefix;
    }

    @Override
    public final MatchingElementName getMatchingElementName() {
        return this.matchingElementName;
    }

    @Override
    public final MatchingAttributeName getMatchingAttributeName() {
        return this.matchingAttributeName;
    }

    @Override
    public final void process(ITemplateContext context, IProcessableElementTag tag, IElementTagStructureHandler structureHandler) {
        try {
            this.doProcess(context, tag, structureHandler);
        }
        catch (TemplateProcessingException e) {
            if (tag.hasLocation()) {
                if (!e.hasTemplateName()) {
                    e.setTemplateName(tag.getTemplateName());
                }
                if (!e.hasLineAndCol()) {
                    e.setLineAndCol(tag.getLine(), tag.getCol());
                }
            }
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", tag.getTemplateName(), tag.getLine(), tag.getCol(), e);
        }
    }

    protected abstract void doProcess(ITemplateContext var1, IProcessableElementTag var2, IElementTagStructureHandler var3);
}

