/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.processor.processinginstruction;

import karate.org.thymeleaf.context.ITemplateContext;
import karate.org.thymeleaf.exceptions.TemplateProcessingException;
import karate.org.thymeleaf.model.IProcessingInstruction;
import karate.org.thymeleaf.processor.AbstractProcessor;
import karate.org.thymeleaf.processor.processinginstruction.IProcessingInstructionProcessor;
import karate.org.thymeleaf.processor.processinginstruction.IProcessingInstructionStructureHandler;
import karate.org.thymeleaf.templatemode.TemplateMode;

public abstract class AbstractProcessingInstructionProcessor
extends AbstractProcessor
implements IProcessingInstructionProcessor {
    public AbstractProcessingInstructionProcessor(TemplateMode templateMode, int precedence) {
        super(templateMode, precedence);
    }

    @Override
    public final void process(ITemplateContext context, IProcessingInstruction processingInstruction, IProcessingInstructionStructureHandler structureHandler) {
        try {
            this.doProcess(context, processingInstruction, structureHandler);
        }
        catch (TemplateProcessingException e) {
            if (processingInstruction.hasLocation()) {
                if (!e.hasTemplateName()) {
                    e.setTemplateName(processingInstruction.getTemplateName());
                }
                if (!e.hasLineAndCol()) {
                    e.setLineAndCol(processingInstruction.getLine(), processingInstruction.getCol());
                }
            }
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", processingInstruction.getTemplateName(), processingInstruction.getLine(), processingInstruction.getCol(), e);
        }
    }

    protected abstract void doProcess(ITemplateContext var1, IProcessingInstruction var2, IProcessingInstructionStructureHandler var3);
}

