/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.processor.xmldeclaration;

import karate.org.thymeleaf.context.ITemplateContext;
import karate.org.thymeleaf.exceptions.TemplateProcessingException;
import karate.org.thymeleaf.model.IXMLDeclaration;
import karate.org.thymeleaf.processor.AbstractProcessor;
import karate.org.thymeleaf.processor.xmldeclaration.IXMLDeclarationProcessor;
import karate.org.thymeleaf.processor.xmldeclaration.IXMLDeclarationStructureHandler;
import karate.org.thymeleaf.templatemode.TemplateMode;

public abstract class AbstractXMLDeclarationProcessor
extends AbstractProcessor
implements IXMLDeclarationProcessor {
    public AbstractXMLDeclarationProcessor(TemplateMode templateMode, int precedence) {
        super(templateMode, precedence);
    }

    @Override
    public final void process(ITemplateContext context, IXMLDeclaration xmlDeclaration, IXMLDeclarationStructureHandler structureHandler) {
        try {
            this.doProcess(context, xmlDeclaration, structureHandler);
        }
        catch (TemplateProcessingException e) {
            if (xmlDeclaration.hasLocation()) {
                if (!e.hasTemplateName()) {
                    e.setTemplateName(xmlDeclaration.getTemplateName());
                }
                if (!e.hasLineAndCol()) {
                    e.setLineAndCol(xmlDeclaration.getLine(), xmlDeclaration.getCol());
                }
            }
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", xmlDeclaration.getTemplateName(), xmlDeclaration.getLine(), xmlDeclaration.getCol(), e);
        }
    }

    protected abstract void doProcess(ITemplateContext var1, IXMLDeclaration var2, IXMLDeclarationStructureHandler var3);
}

