/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.expression;

import karate.org.thymeleaf.context.IExpressionContext;
import karate.org.thymeleaf.standard.expression.IStandardConversionService;
import karate.org.thymeleaf.util.Validate;

public abstract class AbstractStandardConversionService
implements IStandardConversionService {
    protected AbstractStandardConversionService() {
    }

    @Override
    public final <T> T convert(IExpressionContext context, Object object, Class<T> targetClass) {
        Validate.notNull(targetClass, "Target class cannot be null");
        if (targetClass.equals(String.class)) {
            if (object == null || object instanceof String) {
                return (T)object;
            }
            return (T)this.convertToString(context, object);
        }
        return this.convertOther(context, object, targetClass);
    }

    protected String convertToString(IExpressionContext context, Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    protected <T> T convertOther(IExpressionContext context, Object object, Class<T> targetClass) {
        throw new IllegalArgumentException("No available conversion for target class \"" + targetClass.getName() + "\"");
    }
}

