/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.expression;

import java.lang.reflect.Method;
import karate.org.thymeleaf.standard.expression.AdditionExpression;
import karate.org.thymeleaf.standard.expression.BinaryOperationExpression;
import karate.org.thymeleaf.standard.expression.ExpressionParsingState;
import karate.org.thymeleaf.standard.expression.GenericTokenExpression;
import karate.org.thymeleaf.standard.expression.IStandardExpression;
import karate.org.thymeleaf.standard.expression.NumberTokenExpression;
import karate.org.thymeleaf.standard.expression.SubtractionExpression;
import karate.org.thymeleaf.standard.expression.Token;

public abstract class AdditionSubtractionExpression
extends BinaryOperationExpression {
    private static final long serialVersionUID = -7977102096580376925L;
    protected static final String ADDITION_OPERATOR = "+";
    protected static final String SUBTRACTION_OPERATOR = "-";
    static final String[] OPERATORS = new String[]{"+", "-"};
    private static final boolean[] LENIENCIES = new boolean[]{false, true};
    private static final Class<? extends BinaryOperationExpression>[] OPERATOR_CLASSES = new Class[]{AdditionExpression.class, SubtractionExpression.class};
    private static final Method LEFT_ALLOWED_METHOD;
    private static final Method RIGHT_ALLOWED_METHOD;

    protected AdditionSubtractionExpression(IStandardExpression left, IStandardExpression right) {
        super(left, right);
    }

    static boolean isRightAllowed(IStandardExpression right) {
        return right != null && (!(right instanceof Token) || right instanceof NumberTokenExpression || right instanceof GenericTokenExpression);
    }

    static boolean isLeftAllowed(IStandardExpression left) {
        return left != null && (!(left instanceof Token) || left instanceof NumberTokenExpression || left instanceof GenericTokenExpression);
    }

    static ExpressionParsingState composeAdditionSubtractionExpression(ExpressionParsingState state, int nodeIndex) {
        return AdditionSubtractionExpression.composeBinaryOperationExpression(state, nodeIndex, OPERATORS, LENIENCIES, OPERATOR_CLASSES, LEFT_ALLOWED_METHOD, RIGHT_ALLOWED_METHOD);
    }

    static {
        try {
            LEFT_ALLOWED_METHOD = AdditionSubtractionExpression.class.getDeclaredMethod("isLeftAllowed", IStandardExpression.class);
            RIGHT_ALLOWED_METHOD = AdditionSubtractionExpression.class.getDeclaredMethod("isRightAllowed", IStandardExpression.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

