/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.expression;

import java.lang.reflect.Method;
import karate.org.thymeleaf.TemplateEngine;
import karate.org.thymeleaf.context.IExpressionContext;
import karate.org.thymeleaf.standard.expression.BinaryOperationExpression;
import karate.org.thymeleaf.standard.expression.BooleanTokenExpression;
import karate.org.thymeleaf.standard.expression.ExpressionParsingState;
import karate.org.thymeleaf.standard.expression.IStandardExpression;
import karate.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import karate.org.thymeleaf.standard.expression.Token;
import karate.org.thymeleaf.util.EvaluationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AndExpression
extends BinaryOperationExpression {
    private static final long serialVersionUID = -6085038102412415337L;
    private static final Logger logger = LoggerFactory.getLogger(AndExpression.class);
    private static final String OPERATOR = "and";
    static final String[] OPERATORS = new String[]{"and"};
    private static final boolean[] LENIENCIES = new boolean[]{false};
    private static final Class<? extends BinaryOperationExpression>[] OPERATOR_CLASSES = new Class[]{AndExpression.class};
    private static final Method LEFT_ALLOWED_METHOD;
    private static final Method RIGHT_ALLOWED_METHOD;

    public AndExpression(IStandardExpression left, IStandardExpression right) {
        super(left, right);
    }

    @Override
    public String getStringRepresentation() {
        return this.getStringRepresentation(OPERATOR);
    }

    static boolean isRightAllowed(IStandardExpression right) {
        return right != null && (!(right instanceof Token) || right instanceof BooleanTokenExpression);
    }

    static boolean isLeftAllowed(IStandardExpression left) {
        return left != null && (!(left instanceof Token) || left instanceof BooleanTokenExpression);
    }

    static ExpressionParsingState composeAndExpression(ExpressionParsingState state, int nodeIndex) {
        return AndExpression.composeBinaryOperationExpression(state, nodeIndex, OPERATORS, LENIENCIES, OPERATOR_CLASSES, LEFT_ALLOWED_METHOD, RIGHT_ALLOWED_METHOD);
    }

    static Object executeAnd(IExpressionContext context, AndExpression expression, StandardExpressionExecutionContext expContext) {
        Object leftValue;
        boolean leftBooleanValue;
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating AND expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        if (!(leftBooleanValue = EvaluationUtils.evaluateAsBoolean(leftValue = expression.getLeft().execute(context, expContext)))) {
            return Boolean.FALSE;
        }
        Object rightValue = expression.getRight().execute(context, expContext);
        boolean rightBooleanValue = EvaluationUtils.evaluateAsBoolean(rightValue);
        return rightBooleanValue;
    }

    static {
        try {
            LEFT_ALLOWED_METHOD = AndExpression.class.getDeclaredMethod("isLeftAllowed", IStandardExpression.class);
            RIGHT_ALLOWED_METHOD = AndExpression.class.getDeclaredMethod("isRightAllowed", IStandardExpression.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

