/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.expression;

import karate.org.thymeleaf.TemplateEngine;
import karate.org.thymeleaf.context.IExpressionContext;
import karate.org.thymeleaf.standard.expression.ComplexExpression;
import karate.org.thymeleaf.standard.expression.Expression;
import karate.org.thymeleaf.standard.expression.ExpressionParsingNode;
import karate.org.thymeleaf.standard.expression.ExpressionParsingState;
import karate.org.thymeleaf.standard.expression.ExpressionParsingUtil;
import karate.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import karate.org.thymeleaf.standard.expression.VariableExpression;
import karate.org.thymeleaf.util.EvaluationUtils;
import karate.org.thymeleaf.util.StringUtils;
import karate.org.thymeleaf.util.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConditionalExpression
extends ComplexExpression {
    private static final Logger logger = LoggerFactory.getLogger(ConditionalExpression.class);
    private static final long serialVersionUID = -6966177717462316363L;
    private static final char CONDITION_SUFFIX_CHAR = '?';
    private static final char CONDITION_THENELSE_SEPARATOR_CHAR = ':';
    static final String[] OPERATORS = new String[]{String.valueOf('?'), String.valueOf(':')};
    private final Expression conditionExpression;
    private final Expression thenExpression;
    private final Expression elseExpression;

    public ConditionalExpression(Expression conditionExpression, Expression thenExpression, Expression elseExpression) {
        Validate.notNull(conditionExpression, "Condition expression cannot be null");
        Validate.notNull(thenExpression, "Then expression cannot be null");
        Validate.notNull(elseExpression, "Else expression cannot be null");
        this.conditionExpression = conditionExpression;
        this.thenExpression = thenExpression;
        this.elseExpression = elseExpression;
    }

    public Expression getConditionExpression() {
        return this.conditionExpression;
    }

    public Expression getThenExpression() {
        return this.thenExpression;
    }

    public Expression getElseExpression() {
        return this.elseExpression;
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        if (this.conditionExpression instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.conditionExpression);
            sb.append(')');
        } else {
            sb.append(this.conditionExpression);
        }
        sb.append('?');
        sb.append(' ');
        if (this.thenExpression instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.thenExpression);
            sb.append(')');
        } else {
            sb.append(this.thenExpression);
        }
        sb.append(' ');
        sb.append(':');
        sb.append(' ');
        if (this.elseExpression instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.elseExpression);
            sb.append(')');
        } else {
            sb.append(this.elseExpression);
        }
        return sb.toString();
    }

    static ExpressionParsingState composeConditionalExpression(ExpressionParsingState state, int nodeIndex) {
        String input = ((ExpressionParsingNode)state.get(nodeIndex)).getInput();
        if (StringUtils.isEmptyOrWhitespace(input)) {
            return null;
        }
        int condSuffixPos = input.indexOf(63);
        if (condSuffixPos == -1) {
            return state;
        }
        String condStr = input.substring(0, condSuffixPos);
        String remainder = input.substring(condSuffixPos + 1);
        if (remainder.indexOf(63) != -1) {
            return null;
        }
        int thenElseSepPos = remainder.indexOf(58);
        if (remainder.lastIndexOf(58) != thenElseSepPos) {
            return null;
        }
        String thenStr = null;
        String elseStr = null;
        if (thenElseSepPos != -1) {
            if (thenElseSepPos == 0) {
                return state;
            }
            thenStr = remainder.substring(0, thenElseSepPos);
            elseStr = remainder.substring(thenElseSepPos + 1);
        } else {
            thenStr = remainder;
        }
        Expression condExpr = ExpressionParsingUtil.parseAndCompose(state, condStr);
        if (condExpr == null) {
            return null;
        }
        Expression thenExpr = ExpressionParsingUtil.parseAndCompose(state, thenStr);
        if (thenExpr == null) {
            return null;
        }
        Expression elseExpr = VariableExpression.NULL_VALUE;
        if (elseStr != null && (elseExpr = ExpressionParsingUtil.parseAndCompose(state, elseStr)) == null) {
            return null;
        }
        ConditionalExpression conditionalExpressionResult = new ConditionalExpression(condExpr, thenExpr, elseExpr);
        state.setNode(nodeIndex, conditionalExpressionResult);
        return state;
    }

    static Object executeConditional(IExpressionContext context, ConditionalExpression expression, StandardExpressionExecutionContext expContext) {
        Object condObj;
        boolean cond;
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating conditional expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        if (cond = EvaluationUtils.evaluateAsBoolean(condObj = expression.getConditionExpression().execute(context, expContext))) {
            return expression.getThenExpression().execute(context, expContext);
        }
        return expression.getElseExpression().execute(context, expContext);
    }
}

