/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.expression;

import karate.org.thymeleaf.IEngineConfiguration;
import karate.org.thymeleaf.context.IExpressionContext;
import karate.org.thymeleaf.exceptions.TemplateProcessingException;
import karate.org.thymeleaf.standard.expression.Each;
import karate.org.thymeleaf.standard.expression.Expression;
import karate.org.thymeleaf.standard.expression.ExpressionCache;
import karate.org.thymeleaf.standard.expression.ExpressionParsingNode;
import karate.org.thymeleaf.standard.expression.ExpressionParsingState;
import karate.org.thymeleaf.standard.expression.ExpressionParsingUtil;
import karate.org.thymeleaf.standard.expression.StandardExpressionPreprocessor;
import karate.org.thymeleaf.util.StringUtils;
import karate.org.thymeleaf.util.Validate;

public final class EachUtils {
    private static final String OPERATOR = ":";
    private static final String STAT_SEPARATOR = ",";

    public static Each parseEach(IExpressionContext context, String input) {
        Each cachedEach;
        Validate.notNull(context, "Context cannot be null");
        Validate.notNull(input, "Input cannot be null");
        String preprocessedInput = StandardExpressionPreprocessor.preprocess(context, input);
        IEngineConfiguration configuration = context.getConfiguration();
        if (configuration != null && (cachedEach = ExpressionCache.getEachFromCache(configuration, preprocessedInput)) != null) {
            return cachedEach;
        }
        Each each = EachUtils.internalParseEach(preprocessedInput.trim());
        if (each == null) {
            throw new TemplateProcessingException("Could not parse as each: \"" + input + "\"");
        }
        if (configuration != null) {
            ExpressionCache.putEachIntoCache(configuration, preprocessedInput, each);
        }
        return each;
    }

    static Each internalParseEach(String input) {
        if (StringUtils.isEmptyOrWhitespace(input)) {
            return null;
        }
        ExpressionParsingState decomposition = ExpressionParsingUtil.decompose(input);
        if (decomposition == null) {
            return null;
        }
        return EachUtils.composeEach(decomposition, 0);
    }

    private static Each composeEach(ExpressionParsingState state, int nodeIndex) {
        Expression iterableExpr;
        Expression statusVarExpr;
        String statusVarStr;
        String iterVarStr;
        if (state == null || nodeIndex >= state.size()) {
            return null;
        }
        if (state.hasExpressionAt(nodeIndex)) {
            return null;
        }
        String input = ((ExpressionParsingNode)state.get(nodeIndex)).getInput();
        if (StringUtils.isEmptyOrWhitespace(input)) {
            return null;
        }
        int pointer = ExpressionParsingUtil.parseAsSimpleIndexPlaceholder(input);
        if (pointer != -1) {
            return EachUtils.composeEach(state, pointer);
        }
        int inputLen = input.length();
        int operatorLen = OPERATOR.length();
        int operatorPos = input.indexOf(OPERATOR);
        if (operatorPos == -1 || operatorPos == 0 || operatorPos >= inputLen - operatorLen) {
            return null;
        }
        String left = input.substring(0, operatorPos).trim();
        String iterableStr = input.substring(operatorPos + operatorLen).trim();
        int statPos = left.indexOf(STAT_SEPARATOR);
        if (statPos == -1) {
            iterVarStr = left;
            statusVarStr = null;
        } else {
            if (statPos == 0 || statPos >= left.length() - operatorLen) {
                return null;
            }
            iterVarStr = left.substring(0, statPos);
            statusVarStr = left.substring(statPos + operatorLen);
        }
        Expression iterVarExpr = ExpressionParsingUtil.parseAndCompose(state, iterVarStr);
        if (iterVarStr == null) {
            return null;
        }
        if (statusVarStr != null) {
            statusVarExpr = ExpressionParsingUtil.parseAndCompose(state, statusVarStr);
            if (statusVarExpr == null) {
                return null;
            }
        } else {
            statusVarExpr = null;
        }
        if ((iterableExpr = ExpressionParsingUtil.parseAndCompose(state, iterableStr)) == null) {
            return null;
        }
        return new Each(iterVarExpr, statusVarExpr, iterableExpr);
    }

    private EachUtils() {
    }
}

