/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.expression;

import java.lang.reflect.Method;
import karate.org.thymeleaf.standard.expression.BinaryOperationExpression;
import karate.org.thymeleaf.standard.expression.ExpressionParsingState;
import karate.org.thymeleaf.standard.expression.GenericTokenExpression;
import karate.org.thymeleaf.standard.expression.GreaterOrEqualToExpression;
import karate.org.thymeleaf.standard.expression.GreaterThanExpression;
import karate.org.thymeleaf.standard.expression.IStandardExpression;
import karate.org.thymeleaf.standard.expression.LessOrEqualToExpression;
import karate.org.thymeleaf.standard.expression.LessThanExpression;
import karate.org.thymeleaf.standard.expression.NumberTokenExpression;
import karate.org.thymeleaf.standard.expression.Token;

public abstract class GreaterLesserExpression
extends BinaryOperationExpression {
    private static final long serialVersionUID = 3488922833645278122L;
    protected static final String GREATER_THAN_OPERATOR = ">";
    protected static final String GREATER_OR_EQUAL_TO_OPERATOR = ">=";
    protected static final String LESS_THAN_OPERATOR = "<";
    protected static final String LESS_OR_EQUAL_TO_OPERATOR = "<=";
    protected static final String GREATER_THAN_OPERATOR_2 = "gt";
    protected static final String GREATER_OR_EQUAL_TO_OPERATOR_2 = "ge";
    protected static final String LESS_THAN_OPERATOR_2 = "lt";
    protected static final String LESS_OR_EQUAL_TO_OPERATOR_2 = "le";
    static final String[] OPERATORS = new String[]{">", ">=", "<", "<=", "gt", "ge", "lt", "le"};
    private static final boolean[] LENIENCIES = new boolean[]{false, false, false, false, false, false, false, false};
    private static final Class<? extends BinaryOperationExpression>[] OPERATOR_CLASSES = new Class[]{GreaterThanExpression.class, GreaterOrEqualToExpression.class, LessThanExpression.class, LessOrEqualToExpression.class, GreaterThanExpression.class, GreaterOrEqualToExpression.class, LessThanExpression.class, LessOrEqualToExpression.class};
    private static final Method LEFT_ALLOWED_METHOD;
    private static final Method RIGHT_ALLOWED_METHOD;

    protected GreaterLesserExpression(IStandardExpression left, IStandardExpression right) {
        super(left, right);
    }

    static boolean isRightAllowed(IStandardExpression right) {
        return right != null && (!(right instanceof Token) || right instanceof NumberTokenExpression || right instanceof GenericTokenExpression);
    }

    static boolean isLeftAllowed(IStandardExpression left) {
        return left != null && (!(left instanceof Token) || left instanceof NumberTokenExpression || left instanceof GenericTokenExpression);
    }

    protected static ExpressionParsingState composeGreaterLesserExpression(ExpressionParsingState state, int nodeIndex) {
        return GreaterLesserExpression.composeBinaryOperationExpression(state, nodeIndex, OPERATORS, LENIENCIES, OPERATOR_CLASSES, LEFT_ALLOWED_METHOD, RIGHT_ALLOWED_METHOD);
    }

    static {
        try {
            LEFT_ALLOWED_METHOD = GreaterLesserExpression.class.getDeclaredMethod("isLeftAllowed", IStandardExpression.class);
            RIGHT_ALLOWED_METHOD = GreaterLesserExpression.class.getDeclaredMethod("isRightAllowed", IStandardExpression.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

