/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.expression;

import java.math.BigDecimal;
import karate.org.thymeleaf.TemplateEngine;
import karate.org.thymeleaf.context.IExpressionContext;
import karate.org.thymeleaf.exceptions.TemplateProcessingException;
import karate.org.thymeleaf.standard.expression.ComplexExpression;
import karate.org.thymeleaf.standard.expression.Expression;
import karate.org.thymeleaf.standard.expression.ExpressionParsingNode;
import karate.org.thymeleaf.standard.expression.ExpressionParsingState;
import karate.org.thymeleaf.standard.expression.ExpressionParsingUtil;
import karate.org.thymeleaf.standard.expression.LiteralValue;
import karate.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import karate.org.thymeleaf.util.EvaluationUtils;
import karate.org.thymeleaf.util.StringUtils;
import karate.org.thymeleaf.util.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MinusExpression
extends ComplexExpression {
    private static final long serialVersionUID = -9056215047277857192L;
    private static final Logger logger = LoggerFactory.getLogger(MinusExpression.class);
    private static final char OPERATOR = '-';
    static final String[] OPERATORS = new String[]{String.valueOf('-')};
    private final Expression operand;

    public MinusExpression(Expression operand) {
        Validate.notNull(operand, "Operand cannot be null");
        this.operand = operand;
    }

    public Expression getOperand() {
        return this.operand;
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        sb.append('-');
        if (this.operand instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.operand);
            sb.append(')');
        } else {
            sb.append(this.operand);
        }
        return sb.toString();
    }

    public static ExpressionParsingState composeMinusExpression(ExpressionParsingState state, int nodeIndex) {
        String input = ((ExpressionParsingNode)state.get(nodeIndex)).getInput();
        if (StringUtils.isEmptyOrWhitespace(input)) {
            return null;
        }
        String trimmedInput = input.trim();
        int operatorPos = trimmedInput.lastIndexOf(45);
        if (operatorPos == -1) {
            return state;
        }
        if (operatorPos != 0) {
            return state;
        }
        String operandStr = trimmedInput.substring(1);
        Expression operandExpr = ExpressionParsingUtil.parseAndCompose(state, operandStr);
        if (operandExpr == null) {
            return null;
        }
        MinusExpression minusExpression = new MinusExpression(operandExpr);
        state.setNode(nodeIndex, minusExpression);
        return state;
    }

    static Object executeMinus(IExpressionContext context, MinusExpression expression, StandardExpressionExecutionContext expContext) {
        BigDecimal operandNumberValue;
        Object operandValue;
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating minus expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        if ((operandValue = expression.getOperand().execute(context, expContext)) == null) {
            operandValue = "null";
        }
        if ((operandNumberValue = EvaluationUtils.evaluateAsNumber(operandValue)) != null) {
            return operandNumberValue.multiply(BigDecimal.valueOf(-1L));
        }
        throw new TemplateProcessingException("Cannot execute minus: operand is \"" + LiteralValue.unwrap(operandValue) + "\"");
    }
}

