/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.expression;

import karate.org.thymeleaf.TemplateEngine;
import karate.org.thymeleaf.context.IExpressionContext;
import karate.org.thymeleaf.standard.expression.NoOpToken;
import karate.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import karate.org.thymeleaf.standard.expression.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NoOpTokenExpression
extends Token {
    private static final Logger logger = LoggerFactory.getLogger(NoOpTokenExpression.class);
    private static final long serialVersionUID = -5180150929940011L;
    private static final NoOpTokenExpression SINGLETON = new NoOpTokenExpression();

    public NoOpTokenExpression() {
        super(null);
    }

    @Override
    public String getStringRepresentation() {
        return "_";
    }

    static NoOpTokenExpression parseNoOpTokenExpression(String input) {
        if (input.length() == 1 && input.charAt(0) == '_') {
            return SINGLETON;
        }
        return null;
    }

    static Object executeNoOpTokenExpression(IExpressionContext context, NoOpTokenExpression expression, StandardExpressionExecutionContext expContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating no-op token: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        return NoOpToken.VALUE;
    }
}

