/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.expression;

import java.math.BigDecimal;
import karate.org.thymeleaf.TemplateEngine;
import karate.org.thymeleaf.context.IExpressionContext;
import karate.org.thymeleaf.standard.expression.EqualsNotEqualsExpression;
import karate.org.thymeleaf.standard.expression.IStandardExpression;
import karate.org.thymeleaf.standard.expression.LiteralValue;
import karate.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import karate.org.thymeleaf.util.EvaluationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NotEqualsExpression
extends EqualsNotEqualsExpression {
    private static final long serialVersionUID = 5831688164085171802L;
    private static final Logger logger = LoggerFactory.getLogger(NotEqualsExpression.class);

    public NotEqualsExpression(IStandardExpression left, IStandardExpression right) {
        super(left, right);
    }

    @Override
    public String getStringRepresentation() {
        return this.getStringRepresentation("!=");
    }

    static Object executeNotEquals(IExpressionContext context, NotEqualsExpression expression, StandardExpressionExecutionContext expContext) {
        Object leftValue = expression.getLeft().execute(context, expContext);
        Object rightValue = expression.getRight().execute(context, expContext);
        leftValue = LiteralValue.unwrap(leftValue);
        rightValue = LiteralValue.unwrap(rightValue);
        if (leftValue == null) {
            return rightValue != null;
        }
        Boolean result = null;
        BigDecimal leftNumberValue = EvaluationUtils.evaluateAsNumber(leftValue);
        BigDecimal rightNumberValue = EvaluationUtils.evaluateAsNumber(rightValue);
        if (leftNumberValue != null && rightNumberValue != null) {
            result = leftNumberValue.compareTo(rightNumberValue) != 0;
        } else {
            if (leftValue instanceof Character) {
                leftValue = leftValue.toString();
            }
            if (rightValue != null && rightValue instanceof Character) {
                rightValue = rightValue.toString();
            }
            result = rightValue != null && leftValue.getClass().equals(rightValue.getClass()) && Comparable.class.isAssignableFrom(leftValue.getClass()) ? Boolean.valueOf(((Comparable)leftValue).compareTo(rightValue) != 0) : Boolean.valueOf(!leftValue.equals(rightValue));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating NOT EQUALS expression: \"{}\". Left is \"{}\", right is \"{}\". Result is \"{}\"", new Object[]{TemplateEngine.threadIndex(), expression.getStringRepresentation(), leftValue, rightValue, result});
        }
        return result;
    }
}

