/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.expression;

import karate.org.thymeleaf.TemplateEngine;
import karate.org.thymeleaf.context.IExpressionContext;
import karate.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import karate.org.thymeleaf.standard.expression.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NullTokenExpression
extends Token {
    private static final Logger logger = LoggerFactory.getLogger(NullTokenExpression.class);
    private static final long serialVersionUID = -927282151625647619L;
    private static final NullTokenExpression SINGLETON = new NullTokenExpression();

    public NullTokenExpression() {
        super(null);
    }

    @Override
    public String getStringRepresentation() {
        return "null";
    }

    static NullTokenExpression parseNullTokenExpression(String input) {
        if ("null".equalsIgnoreCase(input)) {
            return SINGLETON;
        }
        return null;
    }

    static Object executeNullTokenExpression(IExpressionContext context, NullTokenExpression expression, StandardExpressionExecutionContext expContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating null token: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        return expression.getValue();
    }
}

