/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.expression;

import java.math.BigDecimal;
import karate.org.thymeleaf.TemplateEngine;
import karate.org.thymeleaf.context.IExpressionContext;
import karate.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import karate.org.thymeleaf.standard.expression.Token;
import karate.org.thymeleaf.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NumberTokenExpression
extends Token {
    private static final Logger logger = LoggerFactory.getLogger(NumberTokenExpression.class);
    private static final long serialVersionUID = -3729844055243242571L;
    public static final char DECIMAL_POINT = '.';

    static Number computeValue(String value) {
        BigDecimal bigDecimalValue = new BigDecimal(value);
        if (bigDecimalValue.scale() > 0) {
            return bigDecimalValue;
        }
        return bigDecimalValue.toBigInteger();
    }

    public NumberTokenExpression(String value) {
        super(NumberTokenExpression.computeValue(value));
    }

    @Override
    public String getStringRepresentation() {
        Object value = this.getValue();
        if (value instanceof BigDecimal) {
            return ((BigDecimal)this.getValue()).toPlainString();
        }
        return value.toString();
    }

    static NumberTokenExpression parseNumberTokenExpression(String input) {
        if (StringUtils.isEmptyOrWhitespace(input)) {
            return null;
        }
        boolean decimalFound = false;
        int inputLen = input.length();
        for (int i = 0; i < inputLen; ++i) {
            char c = input.charAt(i);
            if (Character.isDigit(c)) continue;
            if (c == '.') {
                if (decimalFound) {
                    return null;
                }
                decimalFound = true;
                continue;
            }
            return null;
        }
        try {
            return new NumberTokenExpression(input);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static Object executeNumberTokenExpression(IExpressionContext context, NumberTokenExpression expression, StandardExpressionExecutionContext expContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating number token: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        return expression.getValue();
    }
}

