/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.expression;

import java.util.Map;
import karate.org.thymeleaf.context.IContext;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.PropertyAccessor;
import ognl.enhance.UnsupportedCompilationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OGNLContextPropertyAccessor
implements PropertyAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OGNLContextPropertyAccessor.class);
    public static final String RESTRICT_REQUEST_PARAMETERS = "%RESTRICT_REQUEST_PARAMETERS%";
    static final String REQUEST_PARAMETERS_RESTRICTED_VARIABLE_NAME = "param";

    OGNLContextPropertyAccessor() {
    }

    public Object getProperty(Map ognlContext, Object target, Object name) throws OgnlException {
        if (!(target instanceof IContext)) {
            throw new IllegalStateException("Wrong target type. This property accessor is only usable for " + IContext.class.getName() + " implementations, and in this case the target object is " + (target == null ? "null" : "of class " + target.getClass().getName()));
        }
        if (REQUEST_PARAMETERS_RESTRICTED_VARIABLE_NAME.equals(name) && ognlContext != null && ognlContext.containsKey(RESTRICT_REQUEST_PARAMETERS)) {
            throw new OgnlException("Access to variable \"" + name + "\" is forbidden in this context. Note some restrictions apply to variable access. For example, direct access to request parameters is forbidden in preprocessing and unescaped expressions, in TEXT template mode, in fragment insertion specifications and in some specific attribute processors.");
        }
        String propertyName = name == null ? null : name.toString();
        IContext context = (IContext)target;
        return context.getVariable(propertyName);
    }

    public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
        throw new UnsupportedOperationException("Cannot set values into VariablesMap instances from OGNL Expressions");
    }

    public String getSourceAccessor(OgnlContext context, Object target, Object index) {
        context.setCurrentAccessor(IContext.class);
        context.setCurrentType(Object.class);
        return ".getVariable(" + index + ")";
    }

    public String getSourceSetter(OgnlContext context, Object target, Object index) {
        throw new UnsupportedCompilationException("Setting expression for " + context.getCurrentObject() + " with index of " + index + " cannot be computed. IVariablesMap implementations are considered read-only by OGNL.");
    }
}

