/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.expression;

public final class StandardExpressionExecutionContext {
    public static final StandardExpressionExecutionContext RESTRICTED = new StandardExpressionExecutionContext(true, true, false, false);
    public static final StandardExpressionExecutionContext RESTRICTED_FORBID_UNSAFE_EXP_RESULTS = new StandardExpressionExecutionContext(true, true, true, false);
    public static final StandardExpressionExecutionContext NORMAL = new StandardExpressionExecutionContext(false, false, false, false);
    private static final StandardExpressionExecutionContext RESTRICTED_WITH_TYPE_CONVERSION = new StandardExpressionExecutionContext(true, true, false, true);
    private static final StandardExpressionExecutionContext RESTRICTED_FORBID_UNSAFE_EXP_RESULTS_WITH_TYPE_CONVERSION = new StandardExpressionExecutionContext(true, true, true, true);
    private static final StandardExpressionExecutionContext NORMAL_WITH_TYPE_CONVERSION = new StandardExpressionExecutionContext(false, false, false, true);
    private final boolean restrictVariableAccess;
    private final boolean restrictInstantiationAndStatic;
    private final boolean forbidUnsafeExpressionResults;
    private final boolean performTypeConversion;

    private StandardExpressionExecutionContext(boolean restrictVariableAccess, boolean restrictInstantiationAndStatic, boolean forbidUnsafeExpressionResults, boolean performTypeConversion) {
        this.restrictVariableAccess = restrictVariableAccess;
        this.restrictInstantiationAndStatic = restrictInstantiationAndStatic;
        this.forbidUnsafeExpressionResults = forbidUnsafeExpressionResults;
        this.performTypeConversion = performTypeConversion;
    }

    public boolean getRestrictVariableAccess() {
        return this.restrictVariableAccess;
    }

    public boolean getRestrictInstantiationAndStatic() {
        return this.restrictInstantiationAndStatic;
    }

    public boolean getForbidUnsafeExpressionResults() {
        return this.forbidUnsafeExpressionResults;
    }

    public boolean getPerformTypeConversion() {
        return this.performTypeConversion;
    }

    public StandardExpressionExecutionContext withoutTypeConversion() {
        if (!this.getPerformTypeConversion()) {
            return this;
        }
        if (this == NORMAL_WITH_TYPE_CONVERSION) {
            return NORMAL;
        }
        if (this == RESTRICTED_WITH_TYPE_CONVERSION) {
            return RESTRICTED;
        }
        if (this == RESTRICTED_FORBID_UNSAFE_EXP_RESULTS_WITH_TYPE_CONVERSION) {
            return RESTRICTED_FORBID_UNSAFE_EXP_RESULTS;
        }
        return new StandardExpressionExecutionContext(this.getRestrictVariableAccess(), this.getRestrictInstantiationAndStatic(), this.getForbidUnsafeExpressionResults(), false);
    }

    public StandardExpressionExecutionContext withTypeConversion() {
        if (this.getPerformTypeConversion()) {
            return this;
        }
        if (this == NORMAL) {
            return NORMAL_WITH_TYPE_CONVERSION;
        }
        if (this == RESTRICTED) {
            return RESTRICTED_WITH_TYPE_CONVERSION;
        }
        if (this == RESTRICTED_FORBID_UNSAFE_EXP_RESULTS) {
            return RESTRICTED_FORBID_UNSAFE_EXP_RESULTS_WITH_TYPE_CONVERSION;
        }
        return new StandardExpressionExecutionContext(this.getRestrictVariableAccess(), this.getRestrictInstantiationAndStatic(), this.getForbidUnsafeExpressionResults(), true);
    }
}

