/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.inline;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StandardInlineMode {
    NONE,
    HTML,
    XML,
    TEXT,
    JAVASCRIPT,
    CSS;

    private static final Logger LOGGER;

    public static StandardInlineMode parse(String mode) {
        if (mode == null || mode.trim().length() == 0) {
            throw new IllegalArgumentException("Inline mode cannot be null or empty");
        }
        if ("NONE".equalsIgnoreCase(mode)) {
            return NONE;
        }
        if ("HTML".equalsIgnoreCase(mode)) {
            return HTML;
        }
        if ("XML".equalsIgnoreCase(mode)) {
            return XML;
        }
        if ("TEXT".equalsIgnoreCase(mode)) {
            return TEXT;
        }
        if ("JAVASCRIPT".equalsIgnoreCase(mode)) {
            return JAVASCRIPT;
        }
        if ("CSS".equalsIgnoreCase(mode)) {
            return CSS;
        }
        throw new IllegalArgumentException("Unrecognized inline mode: " + mode);
    }

    static {
        LOGGER = LoggerFactory.getLogger(StandardInlineMode.class);
    }
}

