/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.processor;

import java.util.List;
import karate.org.thymeleaf.context.ITemplateContext;
import karate.org.thymeleaf.engine.AttributeName;
import karate.org.thymeleaf.exceptions.TemplateAssertionException;
import karate.org.thymeleaf.model.IProcessableElementTag;
import karate.org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import karate.org.thymeleaf.processor.element.IElementTagStructureHandler;
import karate.org.thymeleaf.standard.expression.ExpressionSequence;
import karate.org.thymeleaf.standard.expression.ExpressionSequenceUtils;
import karate.org.thymeleaf.standard.expression.IStandardExpression;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.util.EvaluationUtils;
import karate.org.thymeleaf.util.StringUtils;

public abstract class AbstractStandardAssertionTagProcessor
extends AbstractAttributeTagProcessor {
    protected AbstractStandardAssertionTagProcessor(TemplateMode templateMode, String dialectPrefix, String attrName, int precedence) {
        super(templateMode, dialectPrefix, null, false, attrName, true, precedence, true);
    }

    @Override
    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        if (StringUtils.isEmptyOrWhitespace(attributeValue)) {
            return;
        }
        ExpressionSequence expressionSequence = ExpressionSequenceUtils.parseExpressionSequence(context, attributeValue);
        List<IStandardExpression> expressions = expressionSequence.getExpressions();
        for (IStandardExpression expression : expressions) {
            Object expressionResult = expression.execute(context);
            boolean expressionBooleanResult = EvaluationUtils.evaluateAsBoolean(expressionResult);
            if (expressionBooleanResult) continue;
            throw new TemplateAssertionException(expression.getStringRepresentation(), tag.getTemplateName(), tag.getAttribute(attributeName).getLine(), tag.getAttribute(attributeName).getCol());
        }
    }
}

